/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amp.model.TagMapCopier;
import software.amazon.awssdk.services.amp.model.WorkspaceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceDescription> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(WorkspaceDescription.getter(WorkspaceDescription::workspaceId)).setter(WorkspaceDescription.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(WorkspaceDescription.getter(WorkspaceDescription::alias)).setter(WorkspaceDescription.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(WorkspaceDescription.getter(WorkspaceDescription::arn)).setter(WorkspaceDescription.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<WorkspaceStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(WorkspaceDescription.getter(WorkspaceDescription::status)).setter(WorkspaceDescription.setter(Builder::status)).constructor(WorkspaceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> PROMETHEUS_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prometheusEndpoint").getter(WorkspaceDescription.getter(WorkspaceDescription::prometheusEndpoint)).setter(WorkspaceDescription.setter(Builder::prometheusEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prometheusEndpoint").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(WorkspaceDescription.getter(WorkspaceDescription::createdAt)).setter(WorkspaceDescription.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(WorkspaceDescription.getter(WorkspaceDescription::tags)).setter(WorkspaceDescription.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, ALIAS_FIELD, ARN_FIELD, STATUS_FIELD, PROMETHEUS_ENDPOINT_FIELD, CREATED_AT_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String workspaceId;
    private final String alias;
    private final String arn;
    private final WorkspaceStatus status;
    private final String prometheusEndpoint;
    private final Instant createdAt;
    private final Map<String, String> tags;

    private WorkspaceDescription(BuilderImpl builder) {
        this.workspaceId = builder.workspaceId;
        this.alias = builder.alias;
        this.arn = builder.arn;
        this.status = builder.status;
        this.prometheusEndpoint = builder.prometheusEndpoint;
        this.createdAt = builder.createdAt;
        this.tags = builder.tags;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final String alias() {
        return this.alias;
    }

    public final String arn() {
        return this.arn;
    }

    public final WorkspaceStatus status() {
        return this.status;
    }

    public final String prometheusEndpoint() {
        return this.prometheusEndpoint;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.prometheusEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceDescription)) {
            return false;
        }
        WorkspaceDescription other = (WorkspaceDescription)obj;
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.prometheusEndpoint(), other.prometheusEndpoint()) && Objects.equals(this.createdAt(), other.createdAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspaceDescription").add("WorkspaceId", (Object)this.workspaceId()).add("Alias", (Object)this.alias()).add("Arn", (Object)this.arn()).add("Status", (Object)this.status()).add("PrometheusEndpoint", (Object)this.prometheusEndpoint()).add("CreatedAt", (Object)this.createdAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "prometheusEndpoint": {
                return Optional.ofNullable(clazz.cast(this.prometheusEndpoint()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceDescription, T> g) {
        return obj -> g.apply((WorkspaceDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workspaceId;
        private String alias;
        private String arn;
        private WorkspaceStatus status;
        private String prometheusEndpoint;
        private Instant createdAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceDescription model) {
            this.workspaceId(model.workspaceId);
            this.alias(model.alias);
            this.arn(model.arn);
            this.status(model.status);
            this.prometheusEndpoint(model.prometheusEndpoint);
            this.createdAt(model.createdAt);
            this.tags(model.tags);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final WorkspaceStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(WorkspaceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(WorkspaceStatus status) {
            this.status = status;
            return this;
        }

        public final String getPrometheusEndpoint() {
            return this.prometheusEndpoint;
        }

        public final void setPrometheusEndpoint(String prometheusEndpoint) {
            this.prometheusEndpoint = prometheusEndpoint;
        }

        @Override
        public final Builder prometheusEndpoint(String prometheusEndpoint) {
            this.prometheusEndpoint = prometheusEndpoint;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public WorkspaceDescription build() {
            return new WorkspaceDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceDescription> {
        public Builder workspaceId(String var1);

        public Builder alias(String var1);

        public Builder arn(String var1);

        public Builder status(WorkspaceStatus var1);

        default public Builder status(Consumer<WorkspaceStatus.Builder> status) {
            return this.status((WorkspaceStatus)((WorkspaceStatus.Builder)WorkspaceStatus.builder().applyMutation(status)).build());
        }

        public Builder prometheusEndpoint(String var1);

        public Builder createdAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

