/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.amp.AmpAsyncClient;
import software.amazon.awssdk.services.amp.AmpAsyncClientBuilder;
import software.amazon.awssdk.services.amp.AmpServiceClientConfiguration;
import software.amazon.awssdk.services.amp.DefaultAmpAsyncClient;
import software.amazon.awssdk.services.amp.DefaultAmpBaseClientBuilder;
import software.amazon.awssdk.services.amp.endpoints.AmpEndpointProvider;

@SdkInternalApi
final class DefaultAmpAsyncClientBuilder
extends DefaultAmpBaseClientBuilder<AmpAsyncClientBuilder, AmpAsyncClient>
implements AmpAsyncClientBuilder {
    DefaultAmpAsyncClientBuilder() {
    }

    @Override
    public DefaultAmpAsyncClientBuilder endpointProvider(AmpEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AmpAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAmpAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        AmpServiceClientConfiguration serviceClientConfiguration = AmpServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultAmpAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

