/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.aiops.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.aiops.AiOpsClient;
import software.amazon.awssdk.services.aiops.internal.UserAgentUtils;
import software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsModel;
import software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsRequest;
import software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsResponse;

public class ListInvestigationGroupsIterable
implements SdkIterable<ListInvestigationGroupsResponse> {
    private final AiOpsClient client;
    private final ListInvestigationGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInvestigationGroupsIterable(AiOpsClient client, ListInvestigationGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInvestigationGroupsResponseFetcher();
    }

    public Iterator<ListInvestigationGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListInvestigationGroupsModel> investigationGroups() {
        Function<ListInvestigationGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.investigationGroups() != null) {
                return response.investigationGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInvestigationGroupsResponseFetcher
    implements SyncPageFetcher<ListInvestigationGroupsResponse> {
        private ListInvestigationGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvestigationGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInvestigationGroupsResponse nextPage(ListInvestigationGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListInvestigationGroupsIterable.this.client.listInvestigationGroups(ListInvestigationGroupsIterable.this.firstRequest);
            }
            return ListInvestigationGroupsIterable.this.client.listInvestigationGroups((ListInvestigationGroupsRequest)((Object)ListInvestigationGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

