/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.acmpca.AcmPcaAsyncClient;
import software.amazon.awssdk.services.acmpca.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.acmpca.model.AcmPcaRequest;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportRequest;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrRequest;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrResponse;
import software.amazon.awssdk.services.acmpca.model.GetCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.GetCertificateResponse;
import software.amazon.awssdk.services.acmpca.waiters.AcmPcaAsyncWaiter;
import software.amazon.awssdk.services.acmpca.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultAcmPcaAsyncWaiter
implements AcmPcaAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final AcmPcaAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeCertificateAuthorityAuditReportResponse> auditReportCreatedWaiter;
    private final AsyncWaiter<GetCertificateAuthorityCsrResponse> certificateAuthorityCSRCreatedWaiter;
    private final AsyncWaiter<GetCertificateResponse> certificateIssuedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultAcmPcaAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (AcmPcaAsyncClient)AcmPcaAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.auditReportCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeCertificateAuthorityAuditReportResponse.class).acceptors(DefaultAcmPcaAsyncWaiter.auditReportCreatedWaiterAcceptors())).overrideConfiguration(DefaultAcmPcaAsyncWaiter.auditReportCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.certificateAuthorityCSRCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetCertificateAuthorityCsrResponse.class).acceptors(DefaultAcmPcaAsyncWaiter.certificateAuthorityCSRCreatedWaiterAcceptors())).overrideConfiguration(DefaultAcmPcaAsyncWaiter.certificateAuthorityCSRCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.certificateIssuedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetCertificateResponse.class).acceptors(DefaultAcmPcaAsyncWaiter.certificateIssuedWaiterAcceptors())).overrideConfiguration(DefaultAcmPcaAsyncWaiter.certificateIssuedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeCertificateAuthorityAuditReportResponse>> waitUntilAuditReportCreated(DescribeCertificateAuthorityAuditReportRequest describeCertificateAuthorityAuditReportRequest) {
        return this.auditReportCreatedWaiter.runAsync(() -> this.client.describeCertificateAuthorityAuditReport(this.applyWaitersUserAgent(describeCertificateAuthorityAuditReportRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeCertificateAuthorityAuditReportResponse>> waitUntilAuditReportCreated(DescribeCertificateAuthorityAuditReportRequest describeCertificateAuthorityAuditReportRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.auditReportCreatedWaiter.runAsync(() -> this.client.describeCertificateAuthorityAuditReport(this.applyWaitersUserAgent(describeCertificateAuthorityAuditReportRequest)), DefaultAcmPcaAsyncWaiter.auditReportCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetCertificateAuthorityCsrResponse>> waitUntilCertificateAuthorityCSRCreated(GetCertificateAuthorityCsrRequest getCertificateAuthorityCsrRequest) {
        return this.certificateAuthorityCSRCreatedWaiter.runAsync(() -> this.client.getCertificateAuthorityCsr(this.applyWaitersUserAgent(getCertificateAuthorityCsrRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetCertificateAuthorityCsrResponse>> waitUntilCertificateAuthorityCSRCreated(GetCertificateAuthorityCsrRequest getCertificateAuthorityCsrRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.certificateAuthorityCSRCreatedWaiter.runAsync(() -> this.client.getCertificateAuthorityCsr(this.applyWaitersUserAgent(getCertificateAuthorityCsrRequest)), DefaultAcmPcaAsyncWaiter.certificateAuthorityCSRCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetCertificateResponse>> waitUntilCertificateIssued(GetCertificateRequest getCertificateRequest) {
        return this.certificateIssuedWaiter.runAsync(() -> this.client.getCertificate(this.applyWaitersUserAgent(getCertificateRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetCertificateResponse>> waitUntilCertificateIssued(GetCertificateRequest getCertificateRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.certificateIssuedWaiter.runAsync(() -> this.client.getCertificate(this.applyWaitersUserAgent(getCertificateRequest)), DefaultAcmPcaAsyncWaiter.certificateIssuedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeCertificateAuthorityAuditReportResponse>> auditReportCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeCertificateAuthorityAuditReportResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeCertificateAuthorityAuditReportResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("AuditReportStatus").value(), "SUCCESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("AuditReportStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (AuditReportStatus=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultAcmPcaAsyncWaiter.errorCode(error), "AccessDeniedException"), (String)"A waiter acceptor was matched on error condition (AccessDeniedException) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetCertificateAuthorityCsrResponse>> certificateAuthorityCSRCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetCertificateAuthorityCsrResponse>> result = new ArrayList<WaiterAcceptor<? super GetCertificateAuthorityCsrResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> true));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultAcmPcaAsyncWaiter.errorCode(error), "RequestInProgressException")));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultAcmPcaAsyncWaiter.errorCode(error), "AccessDeniedException"), (String)"A waiter acceptor was matched on error condition (AccessDeniedException) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetCertificateResponse>> certificateIssuedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetCertificateResponse>> result = new ArrayList<WaiterAcceptor<? super GetCertificateResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> true));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultAcmPcaAsyncWaiter.errorCode(error), "RequestInProgressException")));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultAcmPcaAsyncWaiter.errorCode(error), "AccessDeniedException"), (String)"A waiter acceptor was matched on error condition (AccessDeniedException) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration auditReportCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration certificateAuthorityCSRCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration certificateIssuedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static AcmPcaAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends AcmPcaRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AcmPcaRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements AcmPcaAsyncWaiter.Builder {
        private AcmPcaAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public AcmPcaAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public AcmPcaAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public AcmPcaAsyncWaiter.Builder client(AcmPcaAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public AcmPcaAsyncWaiter build() {
            return new DefaultAcmPcaAsyncWaiter(this);
        }
    }
}

