/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCertificateAuthorityResponse extends AcmPcaResponse implements
        ToCopyableBuilder<DescribeCertificateAuthorityResponse.Builder, DescribeCertificateAuthorityResponse> {
    private static final SdkField<CertificateAuthority> CERTIFICATE_AUTHORITY_FIELD = SdkField
            .<CertificateAuthority> builder(MarshallingType.SDK_POJO).memberName("CertificateAuthority")
            .getter(getter(DescribeCertificateAuthorityResponse::certificateAuthority))
            .setter(setter(Builder::certificateAuthority)).constructor(CertificateAuthority::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthority").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_FIELD));

    private final CertificateAuthority certificateAuthority;

    private DescribeCertificateAuthorityResponse(BuilderImpl builder) {
        super(builder);
        this.certificateAuthority = builder.certificateAuthority;
    }

    /**
     * <p>
     * A <a href="https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthority.html">
     * CertificateAuthority</a> structure that contains information about your private CA.
     * </p>
     * 
     * @return A <a href="https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthority.html">
     *         CertificateAuthority</a> structure that contains information about your private CA.
     */
    public final CertificateAuthority certificateAuthority() {
        return certificateAuthority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthority());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCertificateAuthorityResponse)) {
            return false;
        }
        DescribeCertificateAuthorityResponse other = (DescribeCertificateAuthorityResponse) obj;
        return Objects.equals(certificateAuthority(), other.certificateAuthority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCertificateAuthorityResponse").add("CertificateAuthority", certificateAuthority())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateAuthority":
            return Optional.ofNullable(clazz.cast(certificateAuthority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCertificateAuthorityResponse, T> g) {
        return obj -> g.apply((DescribeCertificateAuthorityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AcmPcaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCertificateAuthorityResponse> {
        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthority.html">
         * CertificateAuthority</a> structure that contains information about your private CA.
         * </p>
         * 
         * @param certificateAuthority
         *        A <a href="https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthority.html">
         *        CertificateAuthority</a> structure that contains information about your private CA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthority(CertificateAuthority certificateAuthority);

        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthority.html">
         * CertificateAuthority</a> structure that contains information about your private CA.
         * </p>
         * This is a convenience method that creates an instance of the {@link CertificateAuthority.Builder} avoiding
         * the need to create one manually via {@link CertificateAuthority#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CertificateAuthority.Builder#build()} is called immediately and
         * its result is passed to {@link #certificateAuthority(CertificateAuthority)}.
         * 
         * @param certificateAuthority
         *        a consumer that will call methods on {@link CertificateAuthority.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateAuthority(CertificateAuthority)
         */
        default Builder certificateAuthority(Consumer<CertificateAuthority.Builder> certificateAuthority) {
            return certificateAuthority(CertificateAuthority.builder().applyMutation(certificateAuthority).build());
        }
    }

    static final class BuilderImpl extends AcmPcaResponse.BuilderImpl implements Builder {
        private CertificateAuthority certificateAuthority;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCertificateAuthorityResponse model) {
            super(model);
            certificateAuthority(model.certificateAuthority);
        }

        public final CertificateAuthority.Builder getCertificateAuthority() {
            return certificateAuthority != null ? certificateAuthority.toBuilder() : null;
        }

        public final void setCertificateAuthority(CertificateAuthority.BuilderImpl certificateAuthority) {
            this.certificateAuthority = certificateAuthority != null ? certificateAuthority.build() : null;
        }

        @Override
        public final Builder certificateAuthority(CertificateAuthority certificateAuthority) {
            this.certificateAuthority = certificateAuthority;
            return this;
        }

        @Override
        public DescribeCertificateAuthorityResponse build() {
            return new DescribeCertificateAuthorityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
