/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AccessMethodType {
    CA_REPOSITORY("CA_REPOSITORY"),
    RESOURCE_PKI_MANIFEST("RESOURCE_PKI_MANIFEST"),
    RESOURCE_PKI_NOTIFY("RESOURCE_PKI_NOTIFY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AccessMethodType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessMethodType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AccessMethodType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessMethodType> knownValues() {
        return Stream.of(AccessMethodType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

