/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in
 * the <code>KeyUsage</code> extension.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExtendedKeyUsage implements SdkPojo, Serializable,
        ToCopyableBuilder<ExtendedKeyUsage.Builder, ExtendedKeyUsage> {
    private static final SdkField<String> EXTENDED_KEY_USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtendedKeyUsageType").getter(getter(ExtendedKeyUsage::extendedKeyUsageTypeAsString))
            .setter(setter(Builder::extendedKeyUsageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedKeyUsageType").build())
            .build();

    private static final SdkField<String> EXTENDED_KEY_USAGE_OBJECT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExtendedKeyUsageObjectIdentifier")
            .getter(getter(ExtendedKeyUsage::extendedKeyUsageObjectIdentifier))
            .setter(setter(Builder::extendedKeyUsageObjectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedKeyUsageObjectIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENDED_KEY_USAGE_TYPE_FIELD,
            EXTENDED_KEY_USAGE_OBJECT_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String extendedKeyUsageType;

    private final String extendedKeyUsageObjectIdentifier;

    private ExtendedKeyUsage(BuilderImpl builder) {
        this.extendedKeyUsageType = builder.extendedKeyUsageType;
        this.extendedKeyUsageObjectIdentifier = builder.extendedKeyUsageObjectIdentifier;
    }

    /**
     * <p>
     * Specifies a standard <code>ExtendedKeyUsage</code> as defined as in <a
     * href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #extendedKeyUsageType} will return {@link ExtendedKeyUsageType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #extendedKeyUsageTypeAsString}.
     * </p>
     * 
     * @return Specifies a standard <code>ExtendedKeyUsage</code> as defined as in <a
     *         href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280</a>.
     * @see ExtendedKeyUsageType
     */
    public final ExtendedKeyUsageType extendedKeyUsageType() {
        return ExtendedKeyUsageType.fromValue(extendedKeyUsageType);
    }

    /**
     * <p>
     * Specifies a standard <code>ExtendedKeyUsage</code> as defined as in <a
     * href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #extendedKeyUsageType} will return {@link ExtendedKeyUsageType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #extendedKeyUsageTypeAsString}.
     * </p>
     * 
     * @return Specifies a standard <code>ExtendedKeyUsage</code> as defined as in <a
     *         href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280</a>.
     * @see ExtendedKeyUsageType
     */
    public final String extendedKeyUsageTypeAsString() {
        return extendedKeyUsageType;
    }

    /**
     * <p>
     * Specifies a custom <code>ExtendedKeyUsage</code> with an object identifier (OID).
     * </p>
     * 
     * @return Specifies a custom <code>ExtendedKeyUsage</code> with an object identifier (OID).
     */
    public final String extendedKeyUsageObjectIdentifier() {
        return extendedKeyUsageObjectIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(extendedKeyUsageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(extendedKeyUsageObjectIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendedKeyUsage)) {
            return false;
        }
        ExtendedKeyUsage other = (ExtendedKeyUsage) obj;
        return Objects.equals(extendedKeyUsageTypeAsString(), other.extendedKeyUsageTypeAsString())
                && Objects.equals(extendedKeyUsageObjectIdentifier(), other.extendedKeyUsageObjectIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExtendedKeyUsage").add("ExtendedKeyUsageType", extendedKeyUsageTypeAsString())
                .add("ExtendedKeyUsageObjectIdentifier", extendedKeyUsageObjectIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExtendedKeyUsageType":
            return Optional.ofNullable(clazz.cast(extendedKeyUsageTypeAsString()));
        case "ExtendedKeyUsageObjectIdentifier":
            return Optional.ofNullable(clazz.cast(extendedKeyUsageObjectIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExtendedKeyUsage, T> g) {
        return obj -> g.apply((ExtendedKeyUsage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExtendedKeyUsage> {
        /**
         * <p>
         * Specifies a standard <code>ExtendedKeyUsage</code> as defined as in <a
         * href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280</a>.
         * </p>
         * 
         * @param extendedKeyUsageType
         *        Specifies a standard <code>ExtendedKeyUsage</code> as defined as in <a
         *        href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280</a>.
         * @see ExtendedKeyUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExtendedKeyUsageType
         */
        Builder extendedKeyUsageType(String extendedKeyUsageType);

        /**
         * <p>
         * Specifies a standard <code>ExtendedKeyUsage</code> as defined as in <a
         * href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280</a>.
         * </p>
         * 
         * @param extendedKeyUsageType
         *        Specifies a standard <code>ExtendedKeyUsage</code> as defined as in <a
         *        href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280</a>.
         * @see ExtendedKeyUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExtendedKeyUsageType
         */
        Builder extendedKeyUsageType(ExtendedKeyUsageType extendedKeyUsageType);

        /**
         * <p>
         * Specifies a custom <code>ExtendedKeyUsage</code> with an object identifier (OID).
         * </p>
         * 
         * @param extendedKeyUsageObjectIdentifier
         *        Specifies a custom <code>ExtendedKeyUsage</code> with an object identifier (OID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedKeyUsageObjectIdentifier(String extendedKeyUsageObjectIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String extendedKeyUsageType;

        private String extendedKeyUsageObjectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtendedKeyUsage model) {
            extendedKeyUsageType(model.extendedKeyUsageType);
            extendedKeyUsageObjectIdentifier(model.extendedKeyUsageObjectIdentifier);
        }

        public final String getExtendedKeyUsageType() {
            return extendedKeyUsageType;
        }

        @Override
        public final Builder extendedKeyUsageType(String extendedKeyUsageType) {
            this.extendedKeyUsageType = extendedKeyUsageType;
            return this;
        }

        @Override
        public final Builder extendedKeyUsageType(ExtendedKeyUsageType extendedKeyUsageType) {
            this.extendedKeyUsageType(extendedKeyUsageType == null ? null : extendedKeyUsageType.toString());
            return this;
        }

        public final void setExtendedKeyUsageType(String extendedKeyUsageType) {
            this.extendedKeyUsageType = extendedKeyUsageType;
        }

        public final String getExtendedKeyUsageObjectIdentifier() {
            return extendedKeyUsageObjectIdentifier;
        }

        @Override
        public final Builder extendedKeyUsageObjectIdentifier(String extendedKeyUsageObjectIdentifier) {
            this.extendedKeyUsageObjectIdentifier = extendedKeyUsageObjectIdentifier;
            return this;
        }

        public final void setExtendedKeyUsageObjectIdentifier(String extendedKeyUsageObjectIdentifier) {
            this.extendedKeyUsageObjectIdentifier = extendedKeyUsageObjectIdentifier;
        }

        @Override
        public ExtendedKeyUsage build() {
            return new ExtendedKeyUsage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
