/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCertificateAuthorityAuditReportRequest extends AcmPcaRequest implements
        ToCopyableBuilder<CreateCertificateAuthorityAuditReportRequest.Builder, CreateCertificateAuthorityAuditReportRequest> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateAuthorityArn")
            .getter(getter(CreateCertificateAuthorityAuditReportRequest::certificateAuthorityArn))
            .setter(setter(Builder::certificateAuthorityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build())
            .build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(CreateCertificateAuthorityAuditReportRequest::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> AUDIT_REPORT_RESPONSE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuditReportResponseFormat")
            .getter(getter(CreateCertificateAuthorityAuditReportRequest::auditReportResponseFormatAsString))
            .setter(setter(Builder::auditReportResponseFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditReportResponseFormat").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_AUTHORITY_ARN_FIELD, S3_BUCKET_NAME_FIELD, AUDIT_REPORT_RESPONSE_FORMAT_FIELD));

    private final String certificateAuthorityArn;

    private final String s3BucketName;

    private final String auditReportResponseFormat;

    private CreateCertificateAuthorityAuditReportRequest(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.s3BucketName = builder.s3BucketName;
        this.auditReportResponseFormat = builder.auditReportResponseFormat;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:
     * </p>
     * <p>
     * <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
     * .
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:</p>
     *         <p>
     *         <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>.
     */
    public final String certificateAuthorityArn() {
        return certificateAuthorityArn;
    }

    /**
     * <p>
     * The name of the S3 bucket that will contain the audit report.
     * </p>
     * 
     * @return The name of the S3 bucket that will contain the audit report.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #auditReportResponseFormat} will return {@link AuditReportResponseFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #auditReportResponseFormatAsString}.
     * </p>
     * 
     * @return The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.
     * @see AuditReportResponseFormat
     */
    public final AuditReportResponseFormat auditReportResponseFormat() {
        return AuditReportResponseFormat.fromValue(auditReportResponseFormat);
    }

    /**
     * <p>
     * The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #auditReportResponseFormat} will return {@link AuditReportResponseFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #auditReportResponseFormatAsString}.
     * </p>
     * 
     * @return The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.
     * @see AuditReportResponseFormat
     */
    public final String auditReportResponseFormatAsString() {
        return auditReportResponseFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(auditReportResponseFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCertificateAuthorityAuditReportRequest)) {
            return false;
        }
        CreateCertificateAuthorityAuditReportRequest other = (CreateCertificateAuthorityAuditReportRequest) obj;
        return Objects.equals(certificateAuthorityArn(), other.certificateAuthorityArn())
                && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(auditReportResponseFormatAsString(), other.auditReportResponseFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCertificateAuthorityAuditReportRequest")
                .add("CertificateAuthorityArn", certificateAuthorityArn()).add("S3BucketName", s3BucketName())
                .add("AuditReportResponseFormat", auditReportResponseFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateAuthorityArn":
            return Optional.ofNullable(clazz.cast(certificateAuthorityArn()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "AuditReportResponseFormat":
            return Optional.ofNullable(clazz.cast(auditReportResponseFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCertificateAuthorityAuditReportRequest, T> g) {
        return obj -> g.apply((CreateCertificateAuthorityAuditReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AcmPcaRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCertificateAuthorityAuditReportRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:
         * </p>
         * <p>
         * <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
         * .
         * </p>
         * 
         * @param certificateAuthorityArn
         *        The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:</p>
         *        <p>
         *        <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityArn(String certificateAuthorityArn);

        /**
         * <p>
         * The name of the S3 bucket that will contain the audit report.
         * </p>
         * 
         * @param s3BucketName
         *        The name of the S3 bucket that will contain the audit report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.
         * </p>
         * 
         * @param auditReportResponseFormat
         *        The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.
         * @see AuditReportResponseFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditReportResponseFormat
         */
        Builder auditReportResponseFormat(String auditReportResponseFormat);

        /**
         * <p>
         * The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.
         * </p>
         * 
         * @param auditReportResponseFormat
         *        The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.
         * @see AuditReportResponseFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditReportResponseFormat
         */
        Builder auditReportResponseFormat(AuditReportResponseFormat auditReportResponseFormat);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AcmPcaRequest.BuilderImpl implements Builder {
        private String certificateAuthorityArn;

        private String s3BucketName;

        private String auditReportResponseFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCertificateAuthorityAuditReportRequest model) {
            super(model);
            certificateAuthorityArn(model.certificateAuthorityArn);
            s3BucketName(model.s3BucketName);
            auditReportResponseFormat(model.auditReportResponseFormat);
        }

        public final String getCertificateAuthorityArn() {
            return certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getAuditReportResponseFormat() {
            return auditReportResponseFormat;
        }

        @Override
        public final Builder auditReportResponseFormat(String auditReportResponseFormat) {
            this.auditReportResponseFormat = auditReportResponseFormat;
            return this;
        }

        @Override
        public final Builder auditReportResponseFormat(AuditReportResponseFormat auditReportResponseFormat) {
            this.auditReportResponseFormat(auditReportResponseFormat == null ? null : auditReportResponseFormat.toString());
            return this;
        }

        public final void setAuditReportResponseFormat(String auditReportResponseFormat) {
            this.auditReportResponseFormat = auditReportResponseFormat;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCertificateAuthorityAuditReportRequest build() {
            return new CreateCertificateAuthorityAuditReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
