/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePermissionRequest extends AcmPcaRequest implements
        ToCopyableBuilder<DeletePermissionRequest.Builder, DeletePermissionRequest> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeletePermissionRequest::certificateAuthorityArn)).setter(setter(Builder::certificateAuthorityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build())
            .build();

    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeletePermissionRequest::principal)).setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();

    private static final SdkField<String> SOURCE_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeletePermissionRequest::sourceAccount)).setter(setter(Builder::sourceAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_AUTHORITY_ARN_FIELD, PRINCIPAL_FIELD, SOURCE_ACCOUNT_FIELD));

    private final String certificateAuthorityArn;

    private final String principal;

    private final String sourceAccount;

    private DeletePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.principal = builder.principal;
        this.sourceAccount = builder.sourceAccount;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the private CA that issued the permissions. You can find the CA's ARN by
     * calling the <a>ListCertificateAuthorities</a> action. This must have the following form:
     * </p>
     * <p>
     * <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
     * .
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the private CA that issued the permissions. You can find the CA's ARN
     *         by calling the <a>ListCertificateAuthorities</a> action. This must have the following form: </p>
     *         <p>
     *         <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>.
     */
    public String certificateAuthorityArn() {
        return certificateAuthorityArn;
    }

    /**
     * <p>
     * The AWS service or identity that will have its CA permissions revoked. At this time, the only valid service
     * principal is <code>acm.amazonaws.com</code>
     * </p>
     * 
     * @return The AWS service or identity that will have its CA permissions revoked. At this time, the only valid
     *         service principal is <code>acm.amazonaws.com</code>
     */
    public String principal() {
        return principal;
    }

    /**
     * <p>
     * The AWS account that calls this action.
     * </p>
     * 
     * @return The AWS account that calls this action.
     */
    public String sourceAccount() {
        return sourceAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAccount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePermissionRequest)) {
            return false;
        }
        DeletePermissionRequest other = (DeletePermissionRequest) obj;
        return Objects.equals(certificateAuthorityArn(), other.certificateAuthorityArn())
                && Objects.equals(principal(), other.principal()) && Objects.equals(sourceAccount(), other.sourceAccount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeletePermissionRequest").add("CertificateAuthorityArn", certificateAuthorityArn())
                .add("Principal", principal()).add("SourceAccount", sourceAccount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateAuthorityArn":
            return Optional.ofNullable(clazz.cast(certificateAuthorityArn()));
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "SourceAccount":
            return Optional.ofNullable(clazz.cast(sourceAccount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePermissionRequest, T> g) {
        return obj -> g.apply((DeletePermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AcmPcaRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeletePermissionRequest> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the private CA that issued the permissions. You can find the CA's ARN by
         * calling the <a>ListCertificateAuthorities</a> action. This must have the following form:
         * </p>
         * <p>
         * <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
         * .
         * </p>
         * 
         * @param certificateAuthorityArn
         *        The Amazon Resource Number (ARN) of the private CA that issued the permissions. You can find the CA's
         *        ARN by calling the <a>ListCertificateAuthorities</a> action. This must have the following form: </p>
         *        <p>
         *        <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityArn(String certificateAuthorityArn);

        /**
         * <p>
         * The AWS service or identity that will have its CA permissions revoked. At this time, the only valid service
         * principal is <code>acm.amazonaws.com</code>
         * </p>
         * 
         * @param principal
         *        The AWS service or identity that will have its CA permissions revoked. At this time, the only valid
         *        service principal is <code>acm.amazonaws.com</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        /**
         * <p>
         * The AWS account that calls this action.
         * </p>
         * 
         * @param sourceAccount
         *        The AWS account that calls this action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccount(String sourceAccount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AcmPcaRequest.BuilderImpl implements Builder {
        private String certificateAuthorityArn;

        private String principal;

        private String sourceAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePermissionRequest model) {
            super(model);
            certificateAuthorityArn(model.certificateAuthorityArn);
            principal(model.principal);
            sourceAccount(model.sourceAccount);
        }

        public final String getCertificateAuthorityArn() {
            return certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        public final String getPrincipal() {
            return principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        public final String getSourceAccount() {
            return sourceAccount;
        }

        @Override
        public final Builder sourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        public final void setSourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePermissionRequest build() {
            return new DeletePermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
