/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Certificate revocation information used by the <a>CreateCertificateAuthority</a> and
 * <a>UpdateCertificateAuthority</a> actions. Your private certificate authority (CA) can create and maintain a
 * certificate revocation list (CRL). A CRL contains information about certificates revoked by your CA. For more
 * information, see <a>RevokeCertificate</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevocationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RevocationConfiguration.Builder, RevocationConfiguration> {
    private static final SdkField<CrlConfiguration> CRL_CONFIGURATION_FIELD = SdkField
            .<CrlConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(RevocationConfiguration::crlConfiguration))
            .setter(setter(Builder::crlConfiguration)).constructor(CrlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrlConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRL_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final CrlConfiguration crlConfiguration;

    private RevocationConfiguration(BuilderImpl builder) {
        this.crlConfiguration = builder.crlConfiguration;
    }

    /**
     * <p>
     * Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.
     * </p>
     * 
     * @return Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.
     */
    public CrlConfiguration crlConfiguration() {
        return crlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(crlConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevocationConfiguration)) {
            return false;
        }
        RevocationConfiguration other = (RevocationConfiguration) obj;
        return Objects.equals(crlConfiguration(), other.crlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RevocationConfiguration").add("CrlConfiguration", crlConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrlConfiguration":
            return Optional.ofNullable(clazz.cast(crlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevocationConfiguration, T> g) {
        return obj -> g.apply((RevocationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RevocationConfiguration> {
        /**
         * <p>
         * Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.
         * </p>
         * 
         * @param crlConfiguration
         *        Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crlConfiguration(CrlConfiguration crlConfiguration);

        /**
         * <p>
         * Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.
         * </p>
         * This is a convenience that creates an instance of the {@link CrlConfiguration.Builder} avoiding the need to
         * create one manually via {@link CrlConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CrlConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #crlConfiguration(CrlConfiguration)}.
         * 
         * @param crlConfiguration
         *        a consumer that will call methods on {@link CrlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crlConfiguration(CrlConfiguration)
         */
        default Builder crlConfiguration(Consumer<CrlConfiguration.Builder> crlConfiguration) {
            return crlConfiguration(CrlConfiguration.builder().applyMutation(crlConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CrlConfiguration crlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RevocationConfiguration model) {
            crlConfiguration(model.crlConfiguration);
        }

        public final CrlConfiguration.Builder getCrlConfiguration() {
            return crlConfiguration != null ? crlConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder crlConfiguration(CrlConfiguration crlConfiguration) {
            this.crlConfiguration = crlConfiguration;
            return this;
        }

        public final void setCrlConfiguration(CrlConfiguration.BuilderImpl crlConfiguration) {
            this.crlConfiguration = crlConfiguration != null ? crlConfiguration.build() : null;
        }

        @Override
        public RevocationConfiguration build() {
            return new RevocationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
