/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SigningAlgorithm {
    SHA256_WITHECDSA("SHA256WITHECDSA"),
    SHA384_WITHECDSA("SHA384WITHECDSA"),
    SHA512_WITHECDSA("SHA512WITHECDSA"),
    SHA256_WITHRSA("SHA256WITHRSA"),
    SHA384_WITHRSA("SHA384WITHRSA"),
    SHA512_WITHRSA("SHA512WITHRSA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SigningAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SigningAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SigningAlgorithm.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SigningAlgorithm> knownValues() {
        return Stream.of(SigningAlgorithm.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

