/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure can be used in the <a>ListCertificates</a> action to filter the output of the certificate list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filters implements SdkPojo, Serializable, ToCopyableBuilder<Filters.Builder, Filters> {
    private static final SdkField<List<String>> EXTENDED_KEY_USAGE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Filters::extendedKeyUsageAsStrings))
            .setter(setter(Builder::extendedKeyUsageWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extendedKeyUsage").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> KEY_USAGE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Filters::keyUsageAsStrings))
            .setter(setter(Builder::keyUsageWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyUsage").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> KEY_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Filters::keyTypesAsStrings))
            .setter(setter(Builder::keyTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENDED_KEY_USAGE_FIELD,
            KEY_USAGE_FIELD, KEY_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> extendedKeyUsage;

    private final List<String> keyUsage;

    private final List<String> keyTypes;

    private Filters(BuilderImpl builder) {
        this.extendedKeyUsage = builder.extendedKeyUsage;
        this.keyUsage = builder.keyUsage;
        this.keyTypes = builder.keyTypes;
    }

    /**
     * <p>
     * Specify one or more <a>ExtendedKeyUsage</a> extension values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExtendedKeyUsage()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specify one or more <a>ExtendedKeyUsage</a> extension values.
     */
    public List<ExtendedKeyUsageName> extendedKeyUsage() {
        return ExtendedKeyUsageFilterListCopier.copyStringToEnum(extendedKeyUsage);
    }

    /**
     * Returns true if the ExtendedKeyUsage property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasExtendedKeyUsage() {
        return extendedKeyUsage != null && !(extendedKeyUsage instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify one or more <a>ExtendedKeyUsage</a> extension values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExtendedKeyUsage()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specify one or more <a>ExtendedKeyUsage</a> extension values.
     */
    public List<String> extendedKeyUsageAsStrings() {
        return extendedKeyUsage;
    }

    /**
     * <p>
     * Specify one or more <a>KeyUsage</a> extension values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeyUsage()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specify one or more <a>KeyUsage</a> extension values.
     */
    public List<KeyUsageName> keyUsage() {
        return KeyUsageFilterListCopier.copyStringToEnum(keyUsage);
    }

    /**
     * Returns true if the KeyUsage property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasKeyUsage() {
        return keyUsage != null && !(keyUsage instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify one or more <a>KeyUsage</a> extension values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeyUsage()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specify one or more <a>KeyUsage</a> extension values.
     */
    public List<String> keyUsageAsStrings() {
        return keyUsage;
    }

    /**
     * <p>
     * Specify one or more algorithms that can be used to generate key pairs.
     * </p>
     * <p>
     * Default filtering returns only <code>RSA_2048</code> certificates. To return other certificate types, provide the
     * desired type signatures in a comma-separated list. For example, <code>"keyTypes": ["RSA_2048,RSA_4096"]</code>
     * returns both <code>RSA_2048</code> and <code>RSA_4096</code> certificates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeyTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specify one or more algorithms that can be used to generate key pairs.</p>
     *         <p>
     *         Default filtering returns only <code>RSA_2048</code> certificates. To return other certificate types,
     *         provide the desired type signatures in a comma-separated list. For example,
     *         <code>"keyTypes": ["RSA_2048,RSA_4096"]</code> returns both <code>RSA_2048</code> and
     *         <code>RSA_4096</code> certificates.
     */
    public List<KeyAlgorithm> keyTypes() {
        return KeyAlgorithmListCopier.copyStringToEnum(keyTypes);
    }

    /**
     * Returns true if the KeyTypes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasKeyTypes() {
        return keyTypes != null && !(keyTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify one or more algorithms that can be used to generate key pairs.
     * </p>
     * <p>
     * Default filtering returns only <code>RSA_2048</code> certificates. To return other certificate types, provide the
     * desired type signatures in a comma-separated list. For example, <code>"keyTypes": ["RSA_2048,RSA_4096"]</code>
     * returns both <code>RSA_2048</code> and <code>RSA_4096</code> certificates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeyTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specify one or more algorithms that can be used to generate key pairs.</p>
     *         <p>
     *         Default filtering returns only <code>RSA_2048</code> certificates. To return other certificate types,
     *         provide the desired type signatures in a comma-separated list. For example,
     *         <code>"keyTypes": ["RSA_2048,RSA_4096"]</code> returns both <code>RSA_2048</code> and
     *         <code>RSA_4096</code> certificates.
     */
    public List<String> keyTypesAsStrings() {
        return keyTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(extendedKeyUsageAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(keyUsageAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(keyTypesAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filters)) {
            return false;
        }
        Filters other = (Filters) obj;
        return Objects.equals(extendedKeyUsageAsStrings(), other.extendedKeyUsageAsStrings())
                && Objects.equals(keyUsageAsStrings(), other.keyUsageAsStrings())
                && Objects.equals(keyTypesAsStrings(), other.keyTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Filters").add("ExtendedKeyUsage", extendedKeyUsageAsStrings())
                .add("KeyUsage", keyUsageAsStrings()).add("KeyTypes", keyTypesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "extendedKeyUsage":
            return Optional.ofNullable(clazz.cast(extendedKeyUsageAsStrings()));
        case "keyUsage":
            return Optional.ofNullable(clazz.cast(keyUsageAsStrings()));
        case "keyTypes":
            return Optional.ofNullable(clazz.cast(keyTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Filters, T> g) {
        return obj -> g.apply((Filters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filters> {
        /**
         * <p>
         * Specify one or more <a>ExtendedKeyUsage</a> extension values.
         * </p>
         * 
         * @param extendedKeyUsage
         *        Specify one or more <a>ExtendedKeyUsage</a> extension values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedKeyUsageWithStrings(Collection<String> extendedKeyUsage);

        /**
         * <p>
         * Specify one or more <a>ExtendedKeyUsage</a> extension values.
         * </p>
         * 
         * @param extendedKeyUsage
         *        Specify one or more <a>ExtendedKeyUsage</a> extension values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedKeyUsageWithStrings(String... extendedKeyUsage);

        /**
         * <p>
         * Specify one or more <a>ExtendedKeyUsage</a> extension values.
         * </p>
         * 
         * @param extendedKeyUsage
         *        Specify one or more <a>ExtendedKeyUsage</a> extension values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedKeyUsage(Collection<ExtendedKeyUsageName> extendedKeyUsage);

        /**
         * <p>
         * Specify one or more <a>ExtendedKeyUsage</a> extension values.
         * </p>
         * 
         * @param extendedKeyUsage
         *        Specify one or more <a>ExtendedKeyUsage</a> extension values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedKeyUsage(ExtendedKeyUsageName... extendedKeyUsage);

        /**
         * <p>
         * Specify one or more <a>KeyUsage</a> extension values.
         * </p>
         * 
         * @param keyUsage
         *        Specify one or more <a>KeyUsage</a> extension values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyUsageWithStrings(Collection<String> keyUsage);

        /**
         * <p>
         * Specify one or more <a>KeyUsage</a> extension values.
         * </p>
         * 
         * @param keyUsage
         *        Specify one or more <a>KeyUsage</a> extension values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyUsageWithStrings(String... keyUsage);

        /**
         * <p>
         * Specify one or more <a>KeyUsage</a> extension values.
         * </p>
         * 
         * @param keyUsage
         *        Specify one or more <a>KeyUsage</a> extension values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyUsage(Collection<KeyUsageName> keyUsage);

        /**
         * <p>
         * Specify one or more <a>KeyUsage</a> extension values.
         * </p>
         * 
         * @param keyUsage
         *        Specify one or more <a>KeyUsage</a> extension values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyUsage(KeyUsageName... keyUsage);

        /**
         * <p>
         * Specify one or more algorithms that can be used to generate key pairs.
         * </p>
         * <p>
         * Default filtering returns only <code>RSA_2048</code> certificates. To return other certificate types, provide
         * the desired type signatures in a comma-separated list. For example,
         * <code>"keyTypes": ["RSA_2048,RSA_4096"]</code> returns both <code>RSA_2048</code> and <code>RSA_4096</code>
         * certificates.
         * </p>
         * 
         * @param keyTypes
         *        Specify one or more algorithms that can be used to generate key pairs.</p>
         *        <p>
         *        Default filtering returns only <code>RSA_2048</code> certificates. To return other certificate types,
         *        provide the desired type signatures in a comma-separated list. For example,
         *        <code>"keyTypes": ["RSA_2048,RSA_4096"]</code> returns both <code>RSA_2048</code> and
         *        <code>RSA_4096</code> certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyTypesWithStrings(Collection<String> keyTypes);

        /**
         * <p>
         * Specify one or more algorithms that can be used to generate key pairs.
         * </p>
         * <p>
         * Default filtering returns only <code>RSA_2048</code> certificates. To return other certificate types, provide
         * the desired type signatures in a comma-separated list. For example,
         * <code>"keyTypes": ["RSA_2048,RSA_4096"]</code> returns both <code>RSA_2048</code> and <code>RSA_4096</code>
         * certificates.
         * </p>
         * 
         * @param keyTypes
         *        Specify one or more algorithms that can be used to generate key pairs.</p>
         *        <p>
         *        Default filtering returns only <code>RSA_2048</code> certificates. To return other certificate types,
         *        provide the desired type signatures in a comma-separated list. For example,
         *        <code>"keyTypes": ["RSA_2048,RSA_4096"]</code> returns both <code>RSA_2048</code> and
         *        <code>RSA_4096</code> certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyTypesWithStrings(String... keyTypes);

        /**
         * <p>
         * Specify one or more algorithms that can be used to generate key pairs.
         * </p>
         * <p>
         * Default filtering returns only <code>RSA_2048</code> certificates. To return other certificate types, provide
         * the desired type signatures in a comma-separated list. For example,
         * <code>"keyTypes": ["RSA_2048,RSA_4096"]</code> returns both <code>RSA_2048</code> and <code>RSA_4096</code>
         * certificates.
         * </p>
         * 
         * @param keyTypes
         *        Specify one or more algorithms that can be used to generate key pairs.</p>
         *        <p>
         *        Default filtering returns only <code>RSA_2048</code> certificates. To return other certificate types,
         *        provide the desired type signatures in a comma-separated list. For example,
         *        <code>"keyTypes": ["RSA_2048,RSA_4096"]</code> returns both <code>RSA_2048</code> and
         *        <code>RSA_4096</code> certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyTypes(Collection<KeyAlgorithm> keyTypes);

        /**
         * <p>
         * Specify one or more algorithms that can be used to generate key pairs.
         * </p>
         * <p>
         * Default filtering returns only <code>RSA_2048</code> certificates. To return other certificate types, provide
         * the desired type signatures in a comma-separated list. For example,
         * <code>"keyTypes": ["RSA_2048,RSA_4096"]</code> returns both <code>RSA_2048</code> and <code>RSA_4096</code>
         * certificates.
         * </p>
         * 
         * @param keyTypes
         *        Specify one or more algorithms that can be used to generate key pairs.</p>
         *        <p>
         *        Default filtering returns only <code>RSA_2048</code> certificates. To return other certificate types,
         *        provide the desired type signatures in a comma-separated list. For example,
         *        <code>"keyTypes": ["RSA_2048,RSA_4096"]</code> returns both <code>RSA_2048</code> and
         *        <code>RSA_4096</code> certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyTypes(KeyAlgorithm... keyTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> extendedKeyUsage = DefaultSdkAutoConstructList.getInstance();

        private List<String> keyUsage = DefaultSdkAutoConstructList.getInstance();

        private List<String> keyTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filters model) {
            extendedKeyUsageWithStrings(model.extendedKeyUsage);
            keyUsageWithStrings(model.keyUsage);
            keyTypesWithStrings(model.keyTypes);
        }

        public final Collection<String> getExtendedKeyUsageAsStrings() {
            return extendedKeyUsage;
        }

        @Override
        public final Builder extendedKeyUsageWithStrings(Collection<String> extendedKeyUsage) {
            this.extendedKeyUsage = ExtendedKeyUsageFilterListCopier.copy(extendedKeyUsage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedKeyUsageWithStrings(String... extendedKeyUsage) {
            extendedKeyUsageWithStrings(Arrays.asList(extendedKeyUsage));
            return this;
        }

        @Override
        public final Builder extendedKeyUsage(Collection<ExtendedKeyUsageName> extendedKeyUsage) {
            this.extendedKeyUsage = ExtendedKeyUsageFilterListCopier.copyEnumToString(extendedKeyUsage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedKeyUsage(ExtendedKeyUsageName... extendedKeyUsage) {
            extendedKeyUsage(Arrays.asList(extendedKeyUsage));
            return this;
        }

        public final void setExtendedKeyUsageWithStrings(Collection<String> extendedKeyUsage) {
            this.extendedKeyUsage = ExtendedKeyUsageFilterListCopier.copy(extendedKeyUsage);
        }

        public final Collection<String> getKeyUsageAsStrings() {
            return keyUsage;
        }

        @Override
        public final Builder keyUsageWithStrings(Collection<String> keyUsage) {
            this.keyUsage = KeyUsageFilterListCopier.copy(keyUsage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyUsageWithStrings(String... keyUsage) {
            keyUsageWithStrings(Arrays.asList(keyUsage));
            return this;
        }

        @Override
        public final Builder keyUsage(Collection<KeyUsageName> keyUsage) {
            this.keyUsage = KeyUsageFilterListCopier.copyEnumToString(keyUsage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyUsage(KeyUsageName... keyUsage) {
            keyUsage(Arrays.asList(keyUsage));
            return this;
        }

        public final void setKeyUsageWithStrings(Collection<String> keyUsage) {
            this.keyUsage = KeyUsageFilterListCopier.copy(keyUsage);
        }

        public final Collection<String> getKeyTypesAsStrings() {
            return keyTypes;
        }

        @Override
        public final Builder keyTypesWithStrings(Collection<String> keyTypes) {
            this.keyTypes = KeyAlgorithmListCopier.copy(keyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyTypesWithStrings(String... keyTypes) {
            keyTypesWithStrings(Arrays.asList(keyTypes));
            return this;
        }

        @Override
        public final Builder keyTypes(Collection<KeyAlgorithm> keyTypes) {
            this.keyTypes = KeyAlgorithmListCopier.copyEnumToString(keyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyTypes(KeyAlgorithm... keyTypes) {
            keyTypes(Arrays.asList(keyTypes));
            return this;
        }

        public final void setKeyTypesWithStrings(Collection<String> keyTypes) {
            this.keyTypes = KeyAlgorithmListCopier.copy(keyTypes);
        }

        @Override
        public Filters build() {
            return new Filters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
