/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.acm.model.DomainValidationOption;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DomainValidationOptionMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").isBinary(false).build();
    private static final MarshallingInfo<String> VALIDATIONDOMAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationDomain").isBinary(false).build();
    private static final DomainValidationOptionMarshaller INSTANCE = new DomainValidationOptionMarshaller();

    private DomainValidationOptionMarshaller() {
    }

    public static DomainValidationOptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DomainValidationOption domainValidationOption, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)domainValidationOption, (String)"domainValidationOption");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)domainValidationOption.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)domainValidationOption.validationDomain(), VALIDATIONDOMAIN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

