/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.acm.model.ACMRequest;
import software.amazon.awssdk.services.acm.model.CertificateStatus;
import software.amazon.awssdk.services.acm.model.CertificateStatusesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCertificatesRequest
extends ACMRequest
implements ToCopyableBuilder<Builder, ListCertificatesRequest> {
    private final List<String> certificateStatuses;
    private final String nextToken;
    private final Integer maxItems;

    private ListCertificatesRequest(BuilderImpl builder) {
        super(builder);
        this.certificateStatuses = builder.certificateStatuses;
        this.nextToken = builder.nextToken;
        this.maxItems = builder.maxItems;
    }

    public List<CertificateStatus> certificateStatuses() {
        return TypeConverter.convert(this.certificateStatuses, CertificateStatus::fromValue);
    }

    public List<String> certificateStatusesStrings() {
        return this.certificateStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateStatusesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesRequest)) {
            return false;
        }
        ListCertificatesRequest other = (ListCertificatesRequest)((Object)obj);
        return Objects.equals(this.certificateStatusesStrings(), other.certificateStatusesStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListCertificatesRequest").add("CertificateStatuses", this.certificateStatusesStrings()).add("NextToken", (Object)this.nextToken()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateStatuses": {
                return Optional.of(clazz.cast(this.certificateStatusesStrings()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ACMRequest.BuilderImpl
    implements Builder {
        private List<String> certificateStatuses;
        private String nextToken;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesRequest model) {
            this.certificateStatuses(model.certificateStatuses);
            this.nextToken(model.nextToken);
            this.maxItems(model.maxItems);
        }

        public final Collection<String> getCertificateStatuses() {
            return this.certificateStatuses;
        }

        @Override
        public final Builder certificateStatuses(Collection<String> certificateStatuses) {
            this.certificateStatuses = CertificateStatusesCopier.copy(certificateStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateStatuses(String ... certificateStatuses) {
            this.certificateStatuses(Arrays.asList(certificateStatuses));
            return this;
        }

        public final void setCertificateStatuses(Collection<String> certificateStatuses) {
            this.certificateStatuses = CertificateStatusesCopier.copy(certificateStatuses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListCertificatesRequest build() {
            return new ListCertificatesRequest(this);
        }
    }

    public static interface Builder
    extends ACMRequest.Builder,
    CopyableBuilder<Builder, ListCertificatesRequest> {
        public Builder certificateStatuses(Collection<String> var1);

        public Builder certificateStatuses(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxItems(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

