/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.acm.transform.DomainValidationOptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DomainValidationOption
implements StructuredPojo,
ToCopyableBuilder<Builder, DomainValidationOption> {
    private final String domainName;
    private final String validationDomain;

    private DomainValidationOption(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.validationDomain = builder.validationDomain;
    }

    public String domainName() {
        return this.domainName;
    }

    public String validationDomain() {
        return this.validationDomain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationDomain());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainValidationOption)) {
            return false;
        }
        DomainValidationOption other = (DomainValidationOption)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.validationDomain(), other.validationDomain());
    }

    public String toString() {
        return ToString.builder((String)"DomainValidationOption").add("DomainName", (Object)this.domainName()).add("ValidationDomain", (Object)this.validationDomain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "ValidationDomain": {
                return Optional.of(clazz.cast(this.validationDomain()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainValidationOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String validationDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainValidationOption model) {
            this.domainName(model.domainName);
            this.validationDomain(model.validationDomain);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getValidationDomain() {
            return this.validationDomain;
        }

        @Override
        public final Builder validationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
            return this;
        }

        public final void setValidationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
        }

        public DomainValidationOption build() {
            return new DomainValidationOption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DomainValidationOption> {
        public Builder domainName(String var1);

        public Builder validationDomain(String var1);
    }
}

