/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportCertificateRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ImportCertificateRequest> {
    private final String certificateArn;
    private final ByteBuffer certificate;
    private final ByteBuffer privateKey;
    private final ByteBuffer certificateChain;

    private ImportCertificateRequest(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificate = builder.certificate;
        this.privateKey = builder.privateKey;
        this.certificateChain = builder.certificateChain;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public ByteBuffer certificate() {
        return this.certificate == null ? null : this.certificate.asReadOnlyBuffer();
    }

    public ByteBuffer privateKey() {
        return this.privateKey == null ? null : this.privateKey.asReadOnlyBuffer();
    }

    public ByteBuffer certificateChain() {
        return this.certificateChain == null ? null : this.certificateChain.asReadOnlyBuffer();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateChain());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportCertificateRequest)) {
            return false;
        }
        ImportCertificateRequest other = (ImportCertificateRequest)((Object)obj);
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.privateKey(), other.privateKey()) && Objects.equals(this.certificateChain(), other.certificateChain());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.certificateArn() != null) {
            sb.append("CertificateArn: ").append(this.certificateArn()).append(",");
        }
        if (this.certificate() != null) {
            sb.append("Certificate: ").append(this.certificate()).append(",");
        }
        if (this.privateKey() != null) {
            sb.append("PrivateKey: ").append(this.privateKey()).append(",");
        }
        if (this.certificateChain() != null) {
            sb.append("CertificateChain: ").append(this.certificateChain()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateArn": {
                return Optional.of(clazz.cast(this.certificateArn()));
            }
            case "Certificate": {
                return Optional.of(clazz.cast(this.certificate()));
            }
            case "PrivateKey": {
                return Optional.of(clazz.cast(this.privateKey()));
            }
            case "CertificateChain": {
                return Optional.of(clazz.cast(this.certificateChain()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private ByteBuffer certificate;
        private ByteBuffer privateKey;
        private ByteBuffer certificateChain;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportCertificateRequest model) {
            this.certificateArn(model.certificateArn);
            this.certificate(model.certificate);
            this.privateKey(model.privateKey);
            this.certificateChain(model.certificateChain);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final ByteBuffer getCertificate() {
            return this.certificate;
        }

        @Override
        public final Builder certificate(ByteBuffer certificate) {
            this.certificate = StandardMemberCopier.copy((ByteBuffer)certificate);
            return this;
        }

        public final void setCertificate(ByteBuffer certificate) {
            this.certificate = StandardMemberCopier.copy((ByteBuffer)certificate);
        }

        public final ByteBuffer getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public final Builder privateKey(ByteBuffer privateKey) {
            this.privateKey = StandardMemberCopier.copy((ByteBuffer)privateKey);
            return this;
        }

        public final void setPrivateKey(ByteBuffer privateKey) {
            this.privateKey = StandardMemberCopier.copy((ByteBuffer)privateKey);
        }

        public final ByteBuffer getCertificateChain() {
            return this.certificateChain;
        }

        @Override
        public final Builder certificateChain(ByteBuffer certificateChain) {
            this.certificateChain = StandardMemberCopier.copy((ByteBuffer)certificateChain);
            return this;
        }

        public final void setCertificateChain(ByteBuffer certificateChain) {
            this.certificateChain = StandardMemberCopier.copy((ByteBuffer)certificateChain);
        }

        public ImportCertificateRequest build() {
            return new ImportCertificateRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportCertificateRequest> {
        public Builder certificateArn(String var1);

        public Builder certificate(ByteBuffer var1);

        public Builder privateKey(ByteBuffer var1);

        public Builder certificateChain(ByteBuffer var1);
    }
}

