/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.acm.model.DomainListCopier;
import software.amazon.awssdk.services.acm.model.DomainValidationOption;
import software.amazon.awssdk.services.acm.model.DomainValidationOptionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RequestCertificateRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RequestCertificateRequest> {
    private final String domainName;
    private final List<String> subjectAlternativeNames;
    private final String idempotencyToken;
    private final List<DomainValidationOption> domainValidationOptions;

    private RequestCertificateRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.subjectAlternativeNames = builder.subjectAlternativeNames;
        this.idempotencyToken = builder.idempotencyToken;
        this.domainValidationOptions = builder.domainValidationOptions;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    public List<DomainValidationOption> domainValidationOptions() {
        return this.domainValidationOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.subjectAlternativeNames() == null ? 0 : this.subjectAlternativeNames().hashCode());
        hashCode = 31 * hashCode + (this.idempotencyToken() == null ? 0 : this.idempotencyToken().hashCode());
        hashCode = 31 * hashCode + (this.domainValidationOptions() == null ? 0 : this.domainValidationOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestCertificateRequest)) {
            return false;
        }
        RequestCertificateRequest other = (RequestCertificateRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.subjectAlternativeNames() == null ^ this.subjectAlternativeNames() == null) {
            return false;
        }
        if (other.subjectAlternativeNames() != null && !other.subjectAlternativeNames().equals(this.subjectAlternativeNames())) {
            return false;
        }
        if (other.idempotencyToken() == null ^ this.idempotencyToken() == null) {
            return false;
        }
        if (other.idempotencyToken() != null && !other.idempotencyToken().equals(this.idempotencyToken())) {
            return false;
        }
        if (other.domainValidationOptions() == null ^ this.domainValidationOptions() == null) {
            return false;
        }
        return other.domainValidationOptions() == null || other.domainValidationOptions().equals(this.domainValidationOptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.subjectAlternativeNames() != null) {
            sb.append("SubjectAlternativeNames: ").append(this.subjectAlternativeNames()).append(",");
        }
        if (this.idempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.idempotencyToken()).append(",");
        }
        if (this.domainValidationOptions() != null) {
            sb.append("DomainValidationOptions: ").append(this.domainValidationOptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> subjectAlternativeNames;
        private String idempotencyToken;
        private List<DomainValidationOption> domainValidationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestCertificateRequest model) {
            this.setDomainName(model.domainName);
            this.setSubjectAlternativeNames(model.subjectAlternativeNames);
            this.setIdempotencyToken(model.idempotencyToken);
            this.setDomainValidationOptions(model.domainValidationOptions);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getSubjectAlternativeNames() {
            return this.subjectAlternativeNames;
        }

        @Override
        public final Builder subjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = DomainListCopier.copy(subjectAlternativeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectAlternativeNames(String ... subjectAlternativeNames) {
            this.subjectAlternativeNames(Arrays.asList(subjectAlternativeNames));
            return this;
        }

        public final void setSubjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = DomainListCopier.copy(subjectAlternativeNames);
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public final Collection<DomainValidationOption> getDomainValidationOptions() {
            return this.domainValidationOptions;
        }

        @Override
        public final Builder domainValidationOptions(Collection<DomainValidationOption> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationOptionListCopier.copy(domainValidationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(DomainValidationOption ... domainValidationOptions) {
            this.domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        public final void setDomainValidationOptions(Collection<DomainValidationOption> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationOptionListCopier.copy(domainValidationOptions);
        }

        public RequestCertificateRequest build() {
            return new RequestCertificateRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RequestCertificateRequest> {
        public Builder domainName(String var1);

        public Builder subjectAlternativeNames(Collection<String> var1);

        public Builder subjectAlternativeNames(String ... var1);

        public Builder idempotencyToken(String var1);

        public Builder domainValidationOptions(Collection<DomainValidationOption> var1);

        public Builder domainValidationOptions(DomainValidationOption ... var1);
    }
}

