/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.acm.model.ResourceRecord;

public class ResourceRecordUnmarshaller
implements Unmarshaller<ResourceRecord, JsonUnmarshallerContext> {
    private static final ResourceRecordUnmarshaller INSTANCE = new ResourceRecordUnmarshaller();

    public ResourceRecord unmarshall(JsonUnmarshallerContext context) throws Exception {
        ResourceRecord.Builder resourceRecordBuilder = ResourceRecord.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    resourceRecordBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    resourceRecordBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Value", targetDepth)) {
                    context.nextToken();
                    resourceRecordBuilder.value((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ResourceRecord)resourceRecordBuilder.build();
    }

    public static ResourceRecordUnmarshaller getInstance() {
        return INSTANCE;
    }
}

