/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.acm.model.ResourceRecord;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceRecordMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final ResourceRecordMarshaller INSTANCE = new ResourceRecordMarshaller();

    private ResourceRecordMarshaller() {
    }

    public static ResourceRecordMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceRecord resourceRecord, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceRecord, (String)"resourceRecord");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceRecord.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)resourceRecord.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)resourceRecord.value(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

