/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.acm.model.Filters;

public class FiltersUnmarshaller
implements Unmarshaller<Filters, JsonUnmarshallerContext> {
    private static final FiltersUnmarshaller INSTANCE = new FiltersUnmarshaller();

    public Filters unmarshall(JsonUnmarshallerContext context) throws Exception {
        Filters.Builder filtersBuilder = Filters.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("extendedKeyUsage", targetDepth)) {
                    context.nextToken();
                    filtersBuilder.extendedKeyUsageWithStrings(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("keyUsage", targetDepth)) {
                    context.nextToken();
                    filtersBuilder.keyUsageWithStrings(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("keyTypes", targetDepth)) {
                    context.nextToken();
                    filtersBuilder.keyTypesWithStrings(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Filters)filtersBuilder.build();
    }

    public static FiltersUnmarshaller getInstance() {
        return INSTANCE;
    }
}

