/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.acm.model.ExtendedKeyUsage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ExtendedKeyUsageMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> OID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OID").isBinary(false).build();
    private static final ExtendedKeyUsageMarshaller INSTANCE = new ExtendedKeyUsageMarshaller();

    private ExtendedKeyUsageMarshaller() {
    }

    public static ExtendedKeyUsageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ExtendedKeyUsage extendedKeyUsage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)extendedKeyUsage, (String)"extendedKeyUsage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)extendedKeyUsage.nameAsString(), NAME_BINDING);
            protocolMarshaller.marshall((Object)extendedKeyUsage.oid(), OID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

