/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.acm.model.DomainValidation;
import software.amazon.awssdk.services.acm.transform.ResourceRecordUnmarshaller;

public class DomainValidationUnmarshaller
implements Unmarshaller<DomainValidation, JsonUnmarshallerContext> {
    private static final DomainValidationUnmarshaller INSTANCE = new DomainValidationUnmarshaller();

    public DomainValidation unmarshall(JsonUnmarshallerContext context) throws Exception {
        DomainValidation.Builder domainValidationBuilder = DomainValidation.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DomainName", targetDepth)) {
                    context.nextToken();
                    domainValidationBuilder.domainName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ValidationEmails", targetDepth)) {
                    context.nextToken();
                    domainValidationBuilder.validationEmails(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("ValidationDomain", targetDepth)) {
                    context.nextToken();
                    domainValidationBuilder.validationDomain((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ValidationStatus", targetDepth)) {
                    context.nextToken();
                    domainValidationBuilder.validationStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResourceRecord", targetDepth)) {
                    context.nextToken();
                    domainValidationBuilder.resourceRecord(ResourceRecordUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ValidationMethod", targetDepth)) {
                    context.nextToken();
                    domainValidationBuilder.validationMethod((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DomainValidation)domainValidationBuilder.build();
    }

    public static DomainValidationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

