/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.acm.model.AcmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResendValidationEmailRequest
extends AcmRequest
implements ToCopyableBuilder<Builder, ResendValidationEmailRequest> {
    private final String certificateArn;
    private final String domain;
    private final String validationDomain;

    private ResendValidationEmailRequest(BuilderImpl builder) {
        super(builder);
        this.certificateArn = builder.certificateArn;
        this.domain = builder.domain;
        this.validationDomain = builder.validationDomain;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String domain() {
        return this.domain;
    }

    public String validationDomain() {
        return this.validationDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationDomain());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResendValidationEmailRequest)) {
            return false;
        }
        ResendValidationEmailRequest other = (ResendValidationEmailRequest)((Object)obj);
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.validationDomain(), other.validationDomain());
    }

    public String toString() {
        return ToString.builder((String)"ResendValidationEmailRequest").add("CertificateArn", (Object)this.certificateArn()).add("Domain", (Object)this.domain()).add("ValidationDomain", (Object)this.validationDomain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "ValidationDomain": {
                return Optional.ofNullable(clazz.cast(this.validationDomain()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AcmRequest.BuilderImpl
    implements Builder {
        private String certificateArn;
        private String domain;
        private String validationDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(ResendValidationEmailRequest model) {
            super(model);
            this.certificateArn(model.certificateArn);
            this.domain(model.domain);
            this.validationDomain(model.validationDomain);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getValidationDomain() {
            return this.validationDomain;
        }

        @Override
        public final Builder validationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
            return this;
        }

        public final void setValidationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResendValidationEmailRequest build() {
            return new ResendValidationEmailRequest(this);
        }
    }

    public static interface Builder
    extends AcmRequest.Builder,
    CopyableBuilder<Builder, ResendValidationEmailRequest> {
        public Builder certificateArn(String var1);

        public Builder domain(String var1);

        public Builder validationDomain(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

