/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.acm.model.CertificateDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CertificateDetailMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateArn").isBinary(false).build();
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").isBinary(false).build();
    private static final MarshallingInfo<List> SUBJECTALTERNATIVENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubjectAlternativeNames").isBinary(false).build();
    private static final MarshallingInfo<List> DOMAINVALIDATIONOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainValidationOptions").isBinary(false).build();
    private static final MarshallingInfo<String> SERIAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Serial").isBinary(false).build();
    private static final MarshallingInfo<String> SUBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subject").isBinary(false).build();
    private static final MarshallingInfo<String> ISSUER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Issuer").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();
    private static final MarshallingInfo<Instant> ISSUEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IssuedAt").isBinary(false).build();
    private static final MarshallingInfo<Instant> IMPORTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportedAt").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<Instant> REVOKEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RevokedAt").isBinary(false).build();
    private static final MarshallingInfo<String> REVOCATIONREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RevocationReason").isBinary(false).build();
    private static final MarshallingInfo<Instant> NOTBEFORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotBefore").isBinary(false).build();
    private static final MarshallingInfo<Instant> NOTAFTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotAfter").isBinary(false).build();
    private static final MarshallingInfo<String> KEYALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyAlgorithm").isBinary(false).build();
    private static final MarshallingInfo<String> SIGNATUREALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SignatureAlgorithm").isBinary(false).build();
    private static final MarshallingInfo<List> INUSEBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InUseBy").isBinary(false).build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureReason").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RENEWALSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RenewalSummary").isBinary(false).build();
    private static final CertificateDetailMarshaller INSTANCE = new CertificateDetailMarshaller();

    private CertificateDetailMarshaller() {
    }

    public static CertificateDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CertificateDetail certificateDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)certificateDetail, (String)"certificateDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)certificateDetail.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall(certificateDetail.subjectAlternativeNames(), SUBJECTALTERNATIVENAMES_BINDING);
            protocolMarshaller.marshall(certificateDetail.domainValidationOptions(), DOMAINVALIDATIONOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.serial(), SERIAL_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.subject(), SUBJECT_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.issuer(), ISSUER_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.issuedAt(), ISSUEDAT_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.importedAt(), IMPORTEDAT_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.revokedAt(), REVOKEDAT_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.revocationReasonAsString(), REVOCATIONREASON_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.notBefore(), NOTBEFORE_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.notAfter(), NOTAFTER_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.keyAlgorithmAsString(), KEYALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.signatureAlgorithm(), SIGNATUREALGORITHM_BINDING);
            protocolMarshaller.marshall(certificateDetail.inUseBy(), INUSEBY_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.failureReasonAsString(), FAILUREREASON_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.renewalSummary(), RENEWALSUMMARY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

