/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.acm.model.AcmRequest;
import software.amazon.awssdk.services.acm.model.DomainListCopier;
import software.amazon.awssdk.services.acm.model.DomainValidationOption;
import software.amazon.awssdk.services.acm.model.DomainValidationOptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestCertificateRequest
extends AcmRequest
implements ToCopyableBuilder<Builder, RequestCertificateRequest> {
    private final String domainName;
    private final List<String> subjectAlternativeNames;
    private final String idempotencyToken;
    private final List<DomainValidationOption> domainValidationOptions;

    private RequestCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.subjectAlternativeNames = builder.subjectAlternativeNames;
        this.idempotencyToken = builder.idempotencyToken;
        this.domainValidationOptions = builder.domainValidationOptions;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    public List<DomainValidationOption> domainValidationOptions() {
        return this.domainValidationOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectAlternativeNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainValidationOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestCertificateRequest)) {
            return false;
        }
        RequestCertificateRequest other = (RequestCertificateRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.subjectAlternativeNames(), other.subjectAlternativeNames()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && Objects.equals(this.domainValidationOptions(), other.domainValidationOptions());
    }

    public String toString() {
        return ToString.builder((String)"RequestCertificateRequest").add("DomainName", (Object)this.domainName()).add("SubjectAlternativeNames", this.subjectAlternativeNames()).add("IdempotencyToken", (Object)this.idempotencyToken()).add("DomainValidationOptions", this.domainValidationOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "SubjectAlternativeNames": {
                return Optional.ofNullable(clazz.cast(this.subjectAlternativeNames()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
            case "DomainValidationOptions": {
                return Optional.ofNullable(clazz.cast(this.domainValidationOptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AcmRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> subjectAlternativeNames = DefaultSdkAutoConstructList.getInstance();
        private String idempotencyToken;
        private List<DomainValidationOption> domainValidationOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RequestCertificateRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.subjectAlternativeNames(model.subjectAlternativeNames);
            this.idempotencyToken(model.idempotencyToken);
            this.domainValidationOptions(model.domainValidationOptions);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getSubjectAlternativeNames() {
            return this.subjectAlternativeNames;
        }

        @Override
        public final Builder subjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = DomainListCopier.copy(subjectAlternativeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectAlternativeNames(String ... subjectAlternativeNames) {
            this.subjectAlternativeNames(Arrays.asList(subjectAlternativeNames));
            return this;
        }

        public final void setSubjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = DomainListCopier.copy(subjectAlternativeNames);
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public final Collection<DomainValidationOption.Builder> getDomainValidationOptions() {
            return this.domainValidationOptions != null ? (Collection)this.domainValidationOptions.stream().map(DomainValidationOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainValidationOptions(Collection<DomainValidationOption> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationOptionListCopier.copy(domainValidationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(DomainValidationOption ... domainValidationOptions) {
            this.domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(Consumer<DomainValidationOption.Builder> ... domainValidationOptions) {
            this.domainValidationOptions(Stream.of(domainValidationOptions).map(c -> (DomainValidationOption)((DomainValidationOption.Builder)DomainValidationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainValidationOptions(Collection<DomainValidationOption.BuilderImpl> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationOptionListCopier.copyFromBuilder(domainValidationOptions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RequestCertificateRequest build() {
            return new RequestCertificateRequest(this);
        }
    }

    public static interface Builder
    extends AcmRequest.Builder,
    CopyableBuilder<Builder, RequestCertificateRequest> {
        public Builder domainName(String var1);

        public Builder subjectAlternativeNames(Collection<String> var1);

        public Builder subjectAlternativeNames(String ... var1);

        public Builder idempotencyToken(String var1);

        public Builder domainValidationOptions(Collection<DomainValidationOption> var1);

        public Builder domainValidationOptions(DomainValidationOption ... var1);

        public Builder domainValidationOptions(Consumer<DomainValidationOption.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

