/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.nio.ByteBuffer;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportCertificateRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ImportCertificateRequest> {
    private final String certificateArn;
    private final ByteBuffer certificate;
    private final ByteBuffer privateKey;
    private final ByteBuffer certificateChain;

    private ImportCertificateRequest(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificate = builder.certificate;
        this.privateKey = builder.privateKey;
        this.certificateChain = builder.certificateChain;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public ByteBuffer certificate() {
        return this.certificate;
    }

    public ByteBuffer privateKey() {
        return this.privateKey;
    }

    public ByteBuffer certificateChain() {
        return this.certificateChain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certificateArn() == null ? 0 : this.certificateArn().hashCode());
        hashCode = 31 * hashCode + (this.certificate() == null ? 0 : this.certificate().hashCode());
        hashCode = 31 * hashCode + (this.privateKey() == null ? 0 : this.privateKey().hashCode());
        hashCode = 31 * hashCode + (this.certificateChain() == null ? 0 : this.certificateChain().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportCertificateRequest)) {
            return false;
        }
        ImportCertificateRequest other = (ImportCertificateRequest)((Object)obj);
        if (other.certificateArn() == null ^ this.certificateArn() == null) {
            return false;
        }
        if (other.certificateArn() != null && !other.certificateArn().equals(this.certificateArn())) {
            return false;
        }
        if (other.certificate() == null ^ this.certificate() == null) {
            return false;
        }
        if (other.certificate() != null && !other.certificate().equals(this.certificate())) {
            return false;
        }
        if (other.privateKey() == null ^ this.privateKey() == null) {
            return false;
        }
        if (other.privateKey() != null && !other.privateKey().equals(this.privateKey())) {
            return false;
        }
        if (other.certificateChain() == null ^ this.certificateChain() == null) {
            return false;
        }
        return other.certificateChain() == null || other.certificateChain().equals(this.certificateChain());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificateArn() != null) {
            sb.append("CertificateArn: ").append(this.certificateArn()).append(",");
        }
        if (this.certificate() != null) {
            sb.append("Certificate: ").append(this.certificate()).append(",");
        }
        if (this.privateKey() != null) {
            sb.append("PrivateKey: ").append(this.privateKey()).append(",");
        }
        if (this.certificateChain() != null) {
            sb.append("CertificateChain: ").append(this.certificateChain()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private ByteBuffer certificate;
        private ByteBuffer privateKey;
        private ByteBuffer certificateChain;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportCertificateRequest model) {
            this.setCertificateArn(model.certificateArn);
            this.setCertificate(model.certificate);
            this.setPrivateKey(model.privateKey);
            this.setCertificateChain(model.certificateChain);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final ByteBuffer getCertificate() {
            return this.certificate;
        }

        @Override
        public final Builder certificate(ByteBuffer certificate) {
            this.certificate = StandardMemberCopier.copy((ByteBuffer)certificate);
            return this;
        }

        public final void setCertificate(ByteBuffer certificate) {
            this.certificate = StandardMemberCopier.copy((ByteBuffer)certificate);
        }

        public final ByteBuffer getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public final Builder privateKey(ByteBuffer privateKey) {
            this.privateKey = StandardMemberCopier.copy((ByteBuffer)privateKey);
            return this;
        }

        public final void setPrivateKey(ByteBuffer privateKey) {
            this.privateKey = StandardMemberCopier.copy((ByteBuffer)privateKey);
        }

        public final ByteBuffer getCertificateChain() {
            return this.certificateChain;
        }

        @Override
        public final Builder certificateChain(ByteBuffer certificateChain) {
            this.certificateChain = StandardMemberCopier.copy((ByteBuffer)certificateChain);
            return this;
        }

        public final void setCertificateChain(ByteBuffer certificateChain) {
            this.certificateChain = StandardMemberCopier.copy((ByteBuffer)certificateChain);
        }

        public ImportCertificateRequest build() {
            return new ImportCertificateRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportCertificateRequest> {
        public Builder certificateArn(String var1);

        public Builder certificate(ByteBuffer var1);

        public Builder privateKey(ByteBuffer var1);

        public Builder certificateChain(ByteBuffer var1);
    }
}

