/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.account.model.AccountRequest;
import software.amazon.awssdk.services.account.model.AlternateContactType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAlternateContactRequest
extends AccountRequest
implements ToCopyableBuilder<Builder, PutAlternateContactRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(PutAlternateContactRequest.getter(PutAlternateContactRequest::accountId)).setter(PutAlternateContactRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> ALTERNATE_CONTACT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlternateContactType").getter(PutAlternateContactRequest.getter(PutAlternateContactRequest::alternateContactTypeAsString)).setter(PutAlternateContactRequest.setter(Builder::alternateContactType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateContactType").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddress").getter(PutAlternateContactRequest.getter(PutAlternateContactRequest::emailAddress)).setter(PutAlternateContactRequest.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PutAlternateContactRequest.getter(PutAlternateContactRequest::name)).setter(PutAlternateContactRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumber").getter(PutAlternateContactRequest.getter(PutAlternateContactRequest::phoneNumber)).setter(PutAlternateContactRequest.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(PutAlternateContactRequest.getter(PutAlternateContactRequest::title)).setter(PutAlternateContactRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ALTERNATE_CONTACT_TYPE_FIELD, EMAIL_ADDRESS_FIELD, NAME_FIELD, PHONE_NUMBER_FIELD, TITLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutAlternateContactRequest.memberNameToFieldInitializer();
    private final String accountId;
    private final String alternateContactType;
    private final String emailAddress;
    private final String name;
    private final String phoneNumber;
    private final String title;

    private PutAlternateContactRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.alternateContactType = builder.alternateContactType;
        this.emailAddress = builder.emailAddress;
        this.name = builder.name;
        this.phoneNumber = builder.phoneNumber;
        this.title = builder.title;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final AlternateContactType alternateContactType() {
        return AlternateContactType.fromValue(this.alternateContactType);
    }

    public final String alternateContactTypeAsString() {
        return this.alternateContactType;
    }

    public final String emailAddress() {
        return this.emailAddress;
    }

    public final String name() {
        return this.name;
    }

    public final String phoneNumber() {
        return this.phoneNumber;
    }

    public final String title() {
        return this.title;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.alternateContactTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAlternateContactRequest)) {
            return false;
        }
        PutAlternateContactRequest other = (PutAlternateContactRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.alternateContactTypeAsString(), other.alternateContactTypeAsString()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.title(), other.title());
    }

    public final String toString() {
        return ToString.builder((String)"PutAlternateContactRequest").add("AccountId", (Object)this.accountId()).add("AlternateContactType", (Object)this.alternateContactTypeAsString()).add("EmailAddress", (Object)(this.emailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("PhoneNumber", (Object)(this.phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("Title", (Object)(this.title() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "AlternateContactType": {
                return Optional.ofNullable(clazz.cast(this.alternateContactTypeAsString()));
            }
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("AlternateContactType", ALTERNATE_CONTACT_TYPE_FIELD);
        map.put("EmailAddress", EMAIL_ADDRESS_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("PhoneNumber", PHONE_NUMBER_FIELD);
        map.put("Title", TITLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAlternateContactRequest, T> g) {
        return obj -> g.apply((PutAlternateContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccountRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String alternateContactType;
        private String emailAddress;
        private String name;
        private String phoneNumber;
        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAlternateContactRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.alternateContactType(model.alternateContactType);
            this.emailAddress(model.emailAddress);
            this.name(model.name);
            this.phoneNumber(model.phoneNumber);
            this.title(model.title);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAlternateContactType() {
            return this.alternateContactType;
        }

        public final void setAlternateContactType(String alternateContactType) {
            this.alternateContactType = alternateContactType;
        }

        @Override
        public final Builder alternateContactType(String alternateContactType) {
            this.alternateContactType = alternateContactType;
            return this;
        }

        @Override
        public final Builder alternateContactType(AlternateContactType alternateContactType) {
            this.alternateContactType(alternateContactType == null ? null : alternateContactType.toString());
            return this;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAlternateContactRequest build() {
            return new PutAlternateContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AccountRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAlternateContactRequest> {
        public Builder accountId(String var1);

        public Builder alternateContactType(String var1);

        public Builder alternateContactType(AlternateContactType var1);

        public Builder emailAddress(String var1);

        public Builder name(String var1);

        public Builder phoneNumber(String var1);

        public Builder title(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

