/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.account.model.AccountResponse;
import software.amazon.awssdk.services.account.model.Region;
import software.amazon.awssdk.services.account.model.RegionOptListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRegionsResponse
extends AccountResponse
implements ToCopyableBuilder<Builder, ListRegionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRegionsResponse.getter(ListRegionsResponse::nextToken)).setter(ListRegionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<Region>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Regions").getter(ListRegionsResponse.getter(ListRegionsResponse::regions)).setter(ListRegionsResponse.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Region::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("Regions", REGIONS_FIELD);
        }
    });
    private final String nextToken;
    private final List<Region> regions;

    private ListRegionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.regions = builder.regions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<Region> regions() {
        return this.regions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegionsResponse)) {
            return false;
        }
        ListRegionsResponse other = (ListRegionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions());
    }

    public final String toString() {
        return ToString.builder((String)"ListRegionsResponse").add("NextToken", (Object)this.nextToken()).add("Regions", this.hasRegions() ? this.regions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRegionsResponse, T> g) {
        return obj -> g.apply((ListRegionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccountResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Region> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.regions(model.regions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Region.Builder> getRegions() {
            List<Region.Builder> result = RegionOptListCopier.copyToBuilder(this.regions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegions(Collection<Region.BuilderImpl> regions) {
            this.regions = RegionOptListCopier.copyFromBuilder(regions);
        }

        @Override
        public final Builder regions(Collection<Region> regions) {
            this.regions = RegionOptListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Region ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Consumer<Region.Builder> ... regions) {
            this.regions(Stream.of(regions).map(c -> (Region)((Region.Builder)Region.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRegionsResponse build() {
            return new ListRegionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AccountResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRegionsResponse> {
        public Builder nextToken(String var1);

        public Builder regions(Collection<Region> var1);

        public Builder regions(Region ... var1);

        public Builder regions(Consumer<Region.Builder> ... var1);
    }
}

