/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.account.AccountClient;
import software.amazon.awssdk.services.account.model.ListRegionsRequest;
import software.amazon.awssdk.services.account.model.ListRegionsResponse;

public class ListRegionsIterable
implements SdkIterable<ListRegionsResponse> {
    private final AccountClient client;
    private final ListRegionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRegionsIterable(AccountClient client, ListRegionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRegionsResponseFetcher();
    }

    public Iterator<ListRegionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRegionsResponseFetcher
    implements SyncPageFetcher<ListRegionsResponse> {
        private ListRegionsResponseFetcher() {
        }

        public boolean hasNextPage(ListRegionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRegionsResponse nextPage(ListRegionsResponse previousPage) {
            if (previousPage == null) {
                return ListRegionsIterable.this.client.listRegions(ListRegionsIterable.this.firstRequest);
            }
            return ListRegionsIterable.this.client.listRegions((ListRegionsRequest)((Object)ListRegionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

