/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account.endpoints.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.account.endpoints.AccountEndpointParams;
import software.amazon.awssdk.services.account.endpoints.AccountEndpointProvider;
import software.amazon.awssdk.services.account.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.services.account.endpoints.internal.Condition;
import software.amazon.awssdk.services.account.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.account.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.account.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.account.endpoints.internal.Expr;
import software.amazon.awssdk.services.account.endpoints.internal.FnNode;
import software.amazon.awssdk.services.account.endpoints.internal.Identifier;
import software.amazon.awssdk.services.account.endpoints.internal.Literal;
import software.amazon.awssdk.services.account.endpoints.internal.Parameter;
import software.amazon.awssdk.services.account.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.account.endpoints.internal.Parameters;
import software.amazon.awssdk.services.account.endpoints.internal.Rule;
import software.amazon.awssdk.services.account.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.MapUtils;

@SdkInternalApi
public final class DefaultAccountEndpointProvider
implements AccountEndpointProvider {
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultAccountEndpointProvider.ruleSet();

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(AccountEndpointParams endpointParams) {
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultAccountEndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(AwsEndpointProviderUtils.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(AccountEndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.useDualStack() != null) {
            paramsMap.put(Identifier.of("UseDualStack"), Value.fromBool(params.useDualStack()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        return paramsMap;
    }

    private static Rule endpointRule_2() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: FIPS and custom endpoint are not supported");
    }

    private static Rule endpointRule_4() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: Dualstack and custom endpoint are not supported");
    }

    private static Rule endpointRule_5() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).build());
    }

    private static Rule endpointRule_3() {
        return Rule.builder().treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_4(), DefaultAccountEndpointProvider.endpointRule_5()));
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_2(), DefaultAccountEndpointProvider.endpointRule_3()));
    }

    private static Rule endpointRule_9() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://account-fips.{Region}.api.aws")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("account")))))).build());
    }

    private static Rule endpointRule_8() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_9()));
    }

    private static Rule endpointRule_10() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_7() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_8(), DefaultAccountEndpointProvider.endpointRule_10()));
    }

    private static Rule endpointRule_13() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://account-fips.{Region}.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("account")))))).build());
    }

    private static Rule endpointRule_12() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_13()));
    }

    private static Rule endpointRule_14() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_11() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_12(), DefaultAccountEndpointProvider.endpointRule_14()));
    }

    private static Rule endpointRule_17() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://account.{Region}.api.aws")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("account")))))).build());
    }

    private static Rule endpointRule_16() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_17()));
    }

    private static Rule endpointRule_18() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_15() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_16(), DefaultAccountEndpointProvider.endpointRule_18()));
    }

    private static Rule endpointRule_19() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://account.us-east-1.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("account")))))).build());
    }

    private static Rule endpointRule_6() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws"))).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_7(), DefaultAccountEndpointProvider.endpointRule_11(), DefaultAccountEndpointProvider.endpointRule_15(), DefaultAccountEndpointProvider.endpointRule_19()));
    }

    private static Rule endpointRule_23() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://account-fips.{Region}.api.amazonwebservices.com.cn")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("cn-northwest-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("account")))))).build());
    }

    private static Rule endpointRule_22() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_23()));
    }

    private static Rule endpointRule_24() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_21() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_22(), DefaultAccountEndpointProvider.endpointRule_24()));
    }

    private static Rule endpointRule_27() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://account-fips.{Region}.amazonaws.com.cn")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("cn-northwest-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("account")))))).build());
    }

    private static Rule endpointRule_26() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_27()));
    }

    private static Rule endpointRule_28() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_25() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_26(), DefaultAccountEndpointProvider.endpointRule_28()));
    }

    private static Rule endpointRule_31() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://account.{Region}.api.amazonwebservices.com.cn")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("cn-northwest-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("account")))))).build());
    }

    private static Rule endpointRule_30() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_31()));
    }

    private static Rule endpointRule_32() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_29() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_30(), DefaultAccountEndpointProvider.endpointRule_32()));
    }

    private static Rule endpointRule_33() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://account.cn-northwest-1.amazonaws.com.cn")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("cn-northwest-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("account")))))).build());
    }

    private static Rule endpointRule_20() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-cn"))).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_21(), DefaultAccountEndpointProvider.endpointRule_25(), DefaultAccountEndpointProvider.endpointRule_29(), DefaultAccountEndpointProvider.endpointRule_33()));
    }

    private static Rule endpointRule_36() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://account-fips.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_35() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_36()));
    }

    private static Rule endpointRule_37() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_34() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_35(), DefaultAccountEndpointProvider.endpointRule_37()));
    }

    private static Rule endpointRule_41() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://account-fips.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_40() {
        return Rule.builder().treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_41()));
    }

    private static Rule endpointRule_39() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_40()));
    }

    private static Rule endpointRule_42() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_38() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_39(), DefaultAccountEndpointProvider.endpointRule_42()));
    }

    private static Rule endpointRule_45() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://account.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_44() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_45()));
    }

    private static Rule endpointRule_46() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_43() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_44(), DefaultAccountEndpointProvider.endpointRule_46()));
    }

    private static Rule endpointRule_48() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://account.us-east-1.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("account")))))).build());
    }

    private static Rule endpointRule_49() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-cn-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://account.cn-northwest-1.amazonaws.com.cn")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("cn-northwest-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("account")))))).build());
    }

    private static Rule endpointRule_50() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://account.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_47() {
        return Rule.builder().treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_48(), DefaultAccountEndpointProvider.endpointRule_49(), DefaultAccountEndpointProvider.endpointRule_50()));
    }

    private static Rule endpointRule_0() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("PartitionResult").build()).treeRule(Arrays.asList(DefaultAccountEndpointProvider.endpointRule_1(), DefaultAccountEndpointProvider.endpointRule_6(), DefaultAccountEndpointProvider.endpointRule_20(), DefaultAccountEndpointProvider.endpointRule_34(), DefaultAccountEndpointProvider.endpointRule_38(), DefaultAccountEndpointProvider.endpointRule_43(), DefaultAccountEndpointProvider.endpointRule_47()));
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.0").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("String")).required(false).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request.").build()).addParameter(Parameter.builder().name("UseDualStack").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseDualStack").documentation("When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("UseFIPS").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseFIPS").documentation("When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).build()).addRule(DefaultAccountEndpointProvider.endpointRule_0()).build();
    }
}

