/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the total number of findings for a type of unused access.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnusedAccessTypeStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<UnusedAccessTypeStatistics.Builder, UnusedAccessTypeStatistics> {
    private static final SdkField<String> UNUSED_ACCESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("unusedAccessType").getter(getter(UnusedAccessTypeStatistics::unusedAccessType))
            .setter(setter(Builder::unusedAccessType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedAccessType").build()).build();

    private static final SdkField<Integer> TOTAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("total")
            .getter(getter(UnusedAccessTypeStatistics::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNUSED_ACCESS_TYPE_FIELD,
            TOTAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String unusedAccessType;

    private final Integer total;

    private UnusedAccessTypeStatistics(BuilderImpl builder) {
        this.unusedAccessType = builder.unusedAccessType;
        this.total = builder.total;
    }

    /**
     * <p>
     * The type of unused access.
     * </p>
     * 
     * @return The type of unused access.
     */
    public final String unusedAccessType() {
        return unusedAccessType;
    }

    /**
     * <p>
     * The total number of findings for the specified unused access type.
     * </p>
     * 
     * @return The total number of findings for the specified unused access type.
     */
    public final Integer total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unusedAccessType());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnusedAccessTypeStatistics)) {
            return false;
        }
        UnusedAccessTypeStatistics other = (UnusedAccessTypeStatistics) obj;
        return Objects.equals(unusedAccessType(), other.unusedAccessType()) && Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnusedAccessTypeStatistics").add("UnusedAccessType", unusedAccessType()).add("Total", total())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unusedAccessType":
            return Optional.ofNullable(clazz.cast(unusedAccessType()));
        case "total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("unusedAccessType", UNUSED_ACCESS_TYPE_FIELD);
        map.put("total", TOTAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnusedAccessTypeStatistics, T> g) {
        return obj -> g.apply((UnusedAccessTypeStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnusedAccessTypeStatistics> {
        /**
         * <p>
         * The type of unused access.
         * </p>
         * 
         * @param unusedAccessType
         *        The type of unused access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedAccessType(String unusedAccessType);

        /**
         * <p>
         * The total number of findings for the specified unused access type.
         * </p>
         * 
         * @param total
         *        The total number of findings for the specified unused access type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Integer total);
    }

    static final class BuilderImpl implements Builder {
        private String unusedAccessType;

        private Integer total;

        private BuilderImpl() {
        }

        private BuilderImpl(UnusedAccessTypeStatistics model) {
            unusedAccessType(model.unusedAccessType);
            total(model.total);
        }

        public final String getUnusedAccessType() {
            return unusedAccessType;
        }

        public final void setUnusedAccessType(String unusedAccessType) {
            this.unusedAccessType = unusedAccessType;
        }

        @Override
        public final Builder unusedAccessType(String unusedAccessType) {
            this.unusedAccessType = unusedAccessType;
            return this;
        }

        public final Integer getTotal() {
            return total;
        }

        public final void setTotal(Integer total) {
            this.total = total;
        }

        @Override
        public final Builder total(Integer total) {
            this.total = total;
            return this;
        }

        @Override
        public UnusedAccessTypeStatistics build() {
            return new UnusedAccessTypeStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
