/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about analysis rules for the internal access analyzer. Analysis rules determine which entities
 * will generate findings based on the criteria you define when you create the rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InternalAccessAnalysisRule implements SdkPojo, Serializable,
        ToCopyableBuilder<InternalAccessAnalysisRule.Builder, InternalAccessAnalysisRule> {
    private static final SdkField<List<InternalAccessAnalysisRuleCriteria>> INCLUSIONS_FIELD = SdkField
            .<List<InternalAccessAnalysisRuleCriteria>> builder(MarshallingType.LIST)
            .memberName("inclusions")
            .getter(getter(InternalAccessAnalysisRule::inclusions))
            .setter(setter(Builder::inclusions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inclusions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InternalAccessAnalysisRuleCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(InternalAccessAnalysisRuleCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<InternalAccessAnalysisRuleCriteria> inclusions;

    private InternalAccessAnalysisRule(BuilderImpl builder) {
        this.inclusions = builder.inclusions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inclusions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInclusions() {
        return inclusions != null && !(inclusions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of rules for the internal access analyzer containing criteria to include in analysis. Only resources that
     * meet the rule criteria will generate findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclusions} method.
     * </p>
     * 
     * @return A list of rules for the internal access analyzer containing criteria to include in analysis. Only
     *         resources that meet the rule criteria will generate findings.
     */
    public final List<InternalAccessAnalysisRuleCriteria> inclusions() {
        return inclusions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInclusions() ? inclusions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternalAccessAnalysisRule)) {
            return false;
        }
        InternalAccessAnalysisRule other = (InternalAccessAnalysisRule) obj;
        return hasInclusions() == other.hasInclusions() && Objects.equals(inclusions(), other.inclusions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InternalAccessAnalysisRule").add("Inclusions", hasInclusions() ? inclusions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inclusions":
            return Optional.ofNullable(clazz.cast(inclusions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inclusions", INCLUSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InternalAccessAnalysisRule, T> g) {
        return obj -> g.apply((InternalAccessAnalysisRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InternalAccessAnalysisRule> {
        /**
         * <p>
         * A list of rules for the internal access analyzer containing criteria to include in analysis. Only resources
         * that meet the rule criteria will generate findings.
         * </p>
         * 
         * @param inclusions
         *        A list of rules for the internal access analyzer containing criteria to include in analysis. Only
         *        resources that meet the rule criteria will generate findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusions(Collection<InternalAccessAnalysisRuleCriteria> inclusions);

        /**
         * <p>
         * A list of rules for the internal access analyzer containing criteria to include in analysis. Only resources
         * that meet the rule criteria will generate findings.
         * </p>
         * 
         * @param inclusions
         *        A list of rules for the internal access analyzer containing criteria to include in analysis. Only
         *        resources that meet the rule criteria will generate findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusions(InternalAccessAnalysisRuleCriteria... inclusions);

        /**
         * <p>
         * A list of rules for the internal access analyzer containing criteria to include in analysis. Only resources
         * that meet the rule criteria will generate findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.accessanalyzer.model.InternalAccessAnalysisRuleCriteria.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.accessanalyzer.model.InternalAccessAnalysisRuleCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.accessanalyzer.model.InternalAccessAnalysisRuleCriteria.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #inclusions(List<InternalAccessAnalysisRuleCriteria>)}.
         * 
         * @param inclusions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.accessanalyzer.model.InternalAccessAnalysisRuleCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inclusions(java.util.Collection<InternalAccessAnalysisRuleCriteria>)
         */
        Builder inclusions(Consumer<InternalAccessAnalysisRuleCriteria.Builder>... inclusions);
    }

    static final class BuilderImpl implements Builder {
        private List<InternalAccessAnalysisRuleCriteria> inclusions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InternalAccessAnalysisRule model) {
            inclusions(model.inclusions);
        }

        public final List<InternalAccessAnalysisRuleCriteria.Builder> getInclusions() {
            List<InternalAccessAnalysisRuleCriteria.Builder> result = InternalAccessAnalysisRuleCriteriaListCopier
                    .copyToBuilder(this.inclusions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInclusions(Collection<InternalAccessAnalysisRuleCriteria.BuilderImpl> inclusions) {
            this.inclusions = InternalAccessAnalysisRuleCriteriaListCopier.copyFromBuilder(inclusions);
        }

        @Override
        public final Builder inclusions(Collection<InternalAccessAnalysisRuleCriteria> inclusions) {
            this.inclusions = InternalAccessAnalysisRuleCriteriaListCopier.copy(inclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusions(InternalAccessAnalysisRuleCriteria... inclusions) {
            inclusions(Arrays.asList(inclusions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusions(Consumer<InternalAccessAnalysisRuleCriteria.Builder>... inclusions) {
            inclusions(Stream.of(inclusions).map(c -> InternalAccessAnalysisRuleCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public InternalAccessAnalysisRule build() {
            return new InternalAccessAnalysisRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
