/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFindingRecommendationResponse extends AccessAnalyzerResponse implements
        ToCopyableBuilder<GetFindingRecommendationResponse.Builder, GetFindingRecommendationResponse> {
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(GetFindingRecommendationResponse::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("completedAt")
            .getter(getter(GetFindingRecommendationResponse::completedAt))
            .setter(setter(Builder::completedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetFindingRecommendationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<RecommendationError> ERROR_FIELD = SdkField
            .<RecommendationError> builder(MarshallingType.SDK_POJO).memberName("error")
            .getter(getter(GetFindingRecommendationResponse::error)).setter(setter(Builder::error))
            .constructor(RecommendationError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(GetFindingRecommendationResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<List<RecommendedStep>> RECOMMENDED_STEPS_FIELD = SdkField
            .<List<RecommendedStep>> builder(MarshallingType.LIST)
            .memberName("recommendedSteps")
            .getter(getter(GetFindingRecommendationResponse::recommendedSteps))
            .setter(setter(Builder::recommendedSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendedStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendedStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RECOMMENDATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendationType").getter(getter(GetFindingRecommendationResponse::recommendationTypeAsString))
            .setter(setter(Builder::recommendationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationType").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetFindingRecommendationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STARTED_AT_FIELD,
            COMPLETED_AT_FIELD, NEXT_TOKEN_FIELD, ERROR_FIELD, RESOURCE_ARN_FIELD, RECOMMENDED_STEPS_FIELD,
            RECOMMENDATION_TYPE_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant startedAt;

    private final Instant completedAt;

    private final String nextToken;

    private final RecommendationError error;

    private final String resourceArn;

    private final List<RecommendedStep> recommendedSteps;

    private final String recommendationType;

    private final String status;

    private GetFindingRecommendationResponse(BuilderImpl builder) {
        super(builder);
        this.startedAt = builder.startedAt;
        this.completedAt = builder.completedAt;
        this.nextToken = builder.nextToken;
        this.error = builder.error;
        this.resourceArn = builder.resourceArn;
        this.recommendedSteps = builder.recommendedSteps;
        this.recommendationType = builder.recommendationType;
        this.status = builder.status;
    }

    /**
     * <p>
     * The time at which the retrieval of the finding recommendation was started.
     * </p>
     * 
     * @return The time at which the retrieval of the finding recommendation was started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The time at which the retrieval of the finding recommendation was completed.
     * </p>
     * 
     * @return The time at which the retrieval of the finding recommendation was completed.
     */
    public final Instant completedAt() {
        return completedAt;
    }

    /**
     * <p>
     * A token used for pagination of results returned.
     * </p>
     * 
     * @return A token used for pagination of results returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Detailed information about the reason that the retrieval of a recommendation for the finding failed.
     * </p>
     * 
     * @return Detailed information about the reason that the retrieval of a recommendation for the finding failed.
     */
    public final RecommendationError error() {
        return error;
    }

    /**
     * <p>
     * The ARN of the resource of the finding.
     * </p>
     * 
     * @return The ARN of the resource of the finding.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecommendedSteps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecommendedSteps() {
        return recommendedSteps != null && !(recommendedSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A group of recommended steps for the finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendedSteps} method.
     * </p>
     * 
     * @return A group of recommended steps for the finding.
     */
    public final List<RecommendedStep> recommendedSteps() {
        return recommendedSteps;
    }

    /**
     * <p>
     * The type of recommendation for the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationType} will return {@link RecommendationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #recommendationTypeAsString}.
     * </p>
     * 
     * @return The type of recommendation for the finding.
     * @see RecommendationType
     */
    public final RecommendationType recommendationType() {
        return RecommendationType.fromValue(recommendationType);
    }

    /**
     * <p>
     * The type of recommendation for the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationType} will return {@link RecommendationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #recommendationTypeAsString}.
     * </p>
     * 
     * @return The type of recommendation for the finding.
     * @see RecommendationType
     */
    public final String recommendationTypeAsString() {
        return recommendationType;
    }

    /**
     * <p>
     * The status of the retrieval of the finding recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the retrieval of the finding recommendation.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the retrieval of the finding recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the retrieval of the finding recommendation.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendedSteps() ? recommendedSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recommendationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingRecommendationResponse)) {
            return false;
        }
        GetFindingRecommendationResponse other = (GetFindingRecommendationResponse) obj;
        return Objects.equals(startedAt(), other.startedAt()) && Objects.equals(completedAt(), other.completedAt())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(error(), other.error())
                && Objects.equals(resourceArn(), other.resourceArn()) && hasRecommendedSteps() == other.hasRecommendedSteps()
                && Objects.equals(recommendedSteps(), other.recommendedSteps())
                && Objects.equals(recommendationTypeAsString(), other.recommendationTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFindingRecommendationResponse").add("StartedAt", startedAt())
                .add("CompletedAt", completedAt()).add("NextToken", nextToken()).add("Error", error())
                .add("ResourceArn", resourceArn()).add("RecommendedSteps", hasRecommendedSteps() ? recommendedSteps() : null)
                .add("RecommendationType", recommendationTypeAsString()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "completedAt":
            return Optional.ofNullable(clazz.cast(completedAt()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "recommendedSteps":
            return Optional.ofNullable(clazz.cast(recommendedSteps()));
        case "recommendationType":
            return Optional.ofNullable(clazz.cast(recommendationTypeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("completedAt", COMPLETED_AT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("recommendedSteps", RECOMMENDED_STEPS_FIELD);
        map.put("recommendationType", RECOMMENDATION_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFindingRecommendationResponse, T> g) {
        return obj -> g.apply((GetFindingRecommendationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AccessAnalyzerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetFindingRecommendationResponse> {
        /**
         * <p>
         * The time at which the retrieval of the finding recommendation was started.
         * </p>
         * 
         * @param startedAt
         *        The time at which the retrieval of the finding recommendation was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The time at which the retrieval of the finding recommendation was completed.
         * </p>
         * 
         * @param completedAt
         *        The time at which the retrieval of the finding recommendation was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(Instant completedAt);

        /**
         * <p>
         * A token used for pagination of results returned.
         * </p>
         * 
         * @param nextToken
         *        A token used for pagination of results returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Detailed information about the reason that the retrieval of a recommendation for the finding failed.
         * </p>
         * 
         * @param error
         *        Detailed information about the reason that the retrieval of a recommendation for the finding failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(RecommendationError error);

        /**
         * <p>
         * Detailed information about the reason that the retrieval of a recommendation for the finding failed.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationError.Builder} avoiding the
         * need to create one manually via {@link RecommendationError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationError.Builder#build()} is called immediately and
         * its result is passed to {@link #error(RecommendationError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link RecommendationError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(RecommendationError)
         */
        default Builder error(Consumer<RecommendationError.Builder> error) {
            return error(RecommendationError.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The ARN of the resource of the finding.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the resource of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * A group of recommended steps for the finding.
         * </p>
         * 
         * @param recommendedSteps
         *        A group of recommended steps for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedSteps(Collection<RecommendedStep> recommendedSteps);

        /**
         * <p>
         * A group of recommended steps for the finding.
         * </p>
         * 
         * @param recommendedSteps
         *        A group of recommended steps for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedSteps(RecommendedStep... recommendedSteps);

        /**
         * <p>
         * A group of recommended steps for the finding.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.accessanalyzer.model.RecommendedStep.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.accessanalyzer.model.RecommendedStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.accessanalyzer.model.RecommendedStep.Builder#build()} is called
         * immediately and its result is passed to {@link #recommendedSteps(List<RecommendedStep>)}.
         * 
         * @param recommendedSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.accessanalyzer.model.RecommendedStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendedSteps(java.util.Collection<RecommendedStep>)
         */
        Builder recommendedSteps(Consumer<RecommendedStep.Builder>... recommendedSteps);

        /**
         * <p>
         * The type of recommendation for the finding.
         * </p>
         * 
         * @param recommendationType
         *        The type of recommendation for the finding.
         * @see RecommendationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationType
         */
        Builder recommendationType(String recommendationType);

        /**
         * <p>
         * The type of recommendation for the finding.
         * </p>
         * 
         * @param recommendationType
         *        The type of recommendation for the finding.
         * @see RecommendationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationType
         */
        Builder recommendationType(RecommendationType recommendationType);

        /**
         * <p>
         * The status of the retrieval of the finding recommendation.
         * </p>
         * 
         * @param status
         *        The status of the retrieval of the finding recommendation.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the retrieval of the finding recommendation.
         * </p>
         * 
         * @param status
         *        The status of the retrieval of the finding recommendation.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    static final class BuilderImpl extends AccessAnalyzerResponse.BuilderImpl implements Builder {
        private Instant startedAt;

        private Instant completedAt;

        private String nextToken;

        private RecommendationError error;

        private String resourceArn;

        private List<RecommendedStep> recommendedSteps = DefaultSdkAutoConstructList.getInstance();

        private String recommendationType;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingRecommendationResponse model) {
            super(model);
            startedAt(model.startedAt);
            completedAt(model.completedAt);
            nextToken(model.nextToken);
            error(model.error);
            resourceArn(model.resourceArn);
            recommendedSteps(model.recommendedSteps);
            recommendationType(model.recommendationType);
            status(model.status);
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final RecommendationError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(RecommendationError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(RecommendationError error) {
            this.error = error;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final List<RecommendedStep.Builder> getRecommendedSteps() {
            List<RecommendedStep.Builder> result = RecommendedStepListCopier.copyToBuilder(this.recommendedSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendedSteps(Collection<RecommendedStep.BuilderImpl> recommendedSteps) {
            this.recommendedSteps = RecommendedStepListCopier.copyFromBuilder(recommendedSteps);
        }

        @Override
        public final Builder recommendedSteps(Collection<RecommendedStep> recommendedSteps) {
            this.recommendedSteps = RecommendedStepListCopier.copy(recommendedSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedSteps(RecommendedStep... recommendedSteps) {
            recommendedSteps(Arrays.asList(recommendedSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedSteps(Consumer<RecommendedStep.Builder>... recommendedSteps) {
            recommendedSteps(Stream.of(recommendedSteps).map(c -> RecommendedStep.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRecommendationType() {
            return recommendationType;
        }

        public final void setRecommendationType(String recommendationType) {
            this.recommendationType = recommendationType;
        }

        @Override
        public final Builder recommendationType(String recommendationType) {
            this.recommendationType = recommendationType;
            return this;
        }

        @Override
        public final Builder recommendationType(RecommendationType recommendationType) {
            this.recommendationType(recommendationType == null ? null : recommendationType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetFindingRecommendationResponse build() {
            return new GetFindingRecommendationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
