/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the text for the generated policy and its details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeneratedPolicyResult implements SdkPojo, Serializable,
        ToCopyableBuilder<GeneratedPolicyResult.Builder, GeneratedPolicyResult> {
    private static final SdkField<GeneratedPolicyProperties> PROPERTIES_FIELD = SdkField
            .<GeneratedPolicyProperties> builder(MarshallingType.SDK_POJO).memberName("properties")
            .getter(getter(GeneratedPolicyResult::properties)).setter(setter(Builder::properties))
            .constructor(GeneratedPolicyProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build()).build();

    private static final SdkField<List<GeneratedPolicy>> GENERATED_POLICIES_FIELD = SdkField
            .<List<GeneratedPolicy>> builder(MarshallingType.LIST)
            .memberName("generatedPolicies")
            .getter(getter(GeneratedPolicyResult::generatedPolicies))
            .setter(setter(Builder::generatedPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GeneratedPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(GeneratedPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTIES_FIELD,
            GENERATED_POLICIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GeneratedPolicyProperties properties;

    private final List<GeneratedPolicy> generatedPolicies;

    private GeneratedPolicyResult(BuilderImpl builder) {
        this.properties = builder.properties;
        this.generatedPolicies = builder.generatedPolicies;
    }

    /**
     * <p>
     * A <code>GeneratedPolicyProperties</code> object that contains properties of the generated policy.
     * </p>
     * 
     * @return A <code>GeneratedPolicyProperties</code> object that contains properties of the generated policy.
     */
    public final GeneratedPolicyProperties properties() {
        return properties;
    }

    /**
     * For responses, this returns true if the service returned a value for the GeneratedPolicies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGeneratedPolicies() {
        return generatedPolicies != null && !(generatedPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The text to use as the content for the new policy. The policy is created using the <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGeneratedPolicies} method.
     * </p>
     * 
     * @return The text to use as the content for the new policy. The policy is created using the <a
     *         href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a> action.
     */
    public final List<GeneratedPolicy> generatedPolicies() {
        return generatedPolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        hashCode = 31 * hashCode + Objects.hashCode(hasGeneratedPolicies() ? generatedPolicies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratedPolicyResult)) {
            return false;
        }
        GeneratedPolicyResult other = (GeneratedPolicyResult) obj;
        return Objects.equals(properties(), other.properties()) && hasGeneratedPolicies() == other.hasGeneratedPolicies()
                && Objects.equals(generatedPolicies(), other.generatedPolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeneratedPolicyResult").add("Properties", properties())
                .add("GeneratedPolicies", hasGeneratedPolicies() ? generatedPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "generatedPolicies":
            return Optional.ofNullable(clazz.cast(generatedPolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("properties", PROPERTIES_FIELD);
        map.put("generatedPolicies", GENERATED_POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeneratedPolicyResult, T> g) {
        return obj -> g.apply((GeneratedPolicyResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeneratedPolicyResult> {
        /**
         * <p>
         * A <code>GeneratedPolicyProperties</code> object that contains properties of the generated policy.
         * </p>
         * 
         * @param properties
         *        A <code>GeneratedPolicyProperties</code> object that contains properties of the generated policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(GeneratedPolicyProperties properties);

        /**
         * <p>
         * A <code>GeneratedPolicyProperties</code> object that contains properties of the generated policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeneratedPolicyProperties.Builder}
         * avoiding the need to create one manually via {@link GeneratedPolicyProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeneratedPolicyProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #properties(GeneratedPolicyProperties)}.
         * 
         * @param properties
         *        a consumer that will call methods on {@link GeneratedPolicyProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(GeneratedPolicyProperties)
         */
        default Builder properties(Consumer<GeneratedPolicyProperties.Builder> properties) {
            return properties(GeneratedPolicyProperties.builder().applyMutation(properties).build());
        }

        /**
         * <p>
         * The text to use as the content for the new policy. The policy is created using the <a
         * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a> action.
         * </p>
         * 
         * @param generatedPolicies
         *        The text to use as the content for the new policy. The policy is created using the <a
         *        href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a>
         *        action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedPolicies(Collection<GeneratedPolicy> generatedPolicies);

        /**
         * <p>
         * The text to use as the content for the new policy. The policy is created using the <a
         * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a> action.
         * </p>
         * 
         * @param generatedPolicies
         *        The text to use as the content for the new policy. The policy is created using the <a
         *        href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a>
         *        action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedPolicies(GeneratedPolicy... generatedPolicies);

        /**
         * <p>
         * The text to use as the content for the new policy. The policy is created using the <a
         * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a> action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicy.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #generatedPolicies(List<GeneratedPolicy>)}.
         * 
         * @param generatedPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generatedPolicies(java.util.Collection<GeneratedPolicy>)
         */
        Builder generatedPolicies(Consumer<GeneratedPolicy.Builder>... generatedPolicies);
    }

    static final class BuilderImpl implements Builder {
        private GeneratedPolicyProperties properties;

        private List<GeneratedPolicy> generatedPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeneratedPolicyResult model) {
            properties(model.properties);
            generatedPolicies(model.generatedPolicies);
        }

        public final GeneratedPolicyProperties.Builder getProperties() {
            return properties != null ? properties.toBuilder() : null;
        }

        public final void setProperties(GeneratedPolicyProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(GeneratedPolicyProperties properties) {
            this.properties = properties;
            return this;
        }

        public final List<GeneratedPolicy.Builder> getGeneratedPolicies() {
            List<GeneratedPolicy.Builder> result = GeneratedPolicyListCopier.copyToBuilder(this.generatedPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeneratedPolicies(Collection<GeneratedPolicy.BuilderImpl> generatedPolicies) {
            this.generatedPolicies = GeneratedPolicyListCopier.copyFromBuilder(generatedPolicies);
        }

        @Override
        public final Builder generatedPolicies(Collection<GeneratedPolicy> generatedPolicies) {
            this.generatedPolicies = GeneratedPolicyListCopier.copy(generatedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedPolicies(GeneratedPolicy... generatedPolicies) {
            generatedPolicies(Arrays.asList(generatedPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedPolicies(Consumer<GeneratedPolicy.Builder>... generatedPolicies) {
            generatedPolicies(Stream.of(generatedPolicies).map(c -> GeneratedPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GeneratedPolicyResult build() {
            return new GeneratedPolicyResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
