/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an external access or unused access finding. Only one parameter can be used in a
 * <code>FindingDetails</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingDetails implements SdkPojo, Serializable, ToCopyableBuilder<FindingDetails.Builder, FindingDetails> {
    private static final SdkField<InternalAccessDetails> INTERNAL_ACCESS_DETAILS_FIELD = SdkField
            .<InternalAccessDetails> builder(MarshallingType.SDK_POJO).memberName("internalAccessDetails")
            .getter(getter(FindingDetails::internalAccessDetails)).setter(setter(Builder::internalAccessDetails))
            .constructor(InternalAccessDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("internalAccessDetails").build())
            .build();

    private static final SdkField<ExternalAccessDetails> EXTERNAL_ACCESS_DETAILS_FIELD = SdkField
            .<ExternalAccessDetails> builder(MarshallingType.SDK_POJO).memberName("externalAccessDetails")
            .getter(getter(FindingDetails::externalAccessDetails)).setter(setter(Builder::externalAccessDetails))
            .constructor(ExternalAccessDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalAccessDetails").build())
            .build();

    private static final SdkField<UnusedPermissionDetails> UNUSED_PERMISSION_DETAILS_FIELD = SdkField
            .<UnusedPermissionDetails> builder(MarshallingType.SDK_POJO).memberName("unusedPermissionDetails")
            .getter(getter(FindingDetails::unusedPermissionDetails)).setter(setter(Builder::unusedPermissionDetails))
            .constructor(UnusedPermissionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedPermissionDetails").build())
            .build();

    private static final SdkField<UnusedIamUserAccessKeyDetails> UNUSED_IAM_USER_ACCESS_KEY_DETAILS_FIELD = SdkField
            .<UnusedIamUserAccessKeyDetails> builder(MarshallingType.SDK_POJO)
            .memberName("unusedIamUserAccessKeyDetails")
            .getter(getter(FindingDetails::unusedIamUserAccessKeyDetails))
            .setter(setter(Builder::unusedIamUserAccessKeyDetails))
            .constructor(UnusedIamUserAccessKeyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedIamUserAccessKeyDetails")
                    .build()).build();

    private static final SdkField<UnusedIamRoleDetails> UNUSED_IAM_ROLE_DETAILS_FIELD = SdkField
            .<UnusedIamRoleDetails> builder(MarshallingType.SDK_POJO).memberName("unusedIamRoleDetails")
            .getter(getter(FindingDetails::unusedIamRoleDetails)).setter(setter(Builder::unusedIamRoleDetails))
            .constructor(UnusedIamRoleDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedIamRoleDetails").build())
            .build();

    private static final SdkField<UnusedIamUserPasswordDetails> UNUSED_IAM_USER_PASSWORD_DETAILS_FIELD = SdkField
            .<UnusedIamUserPasswordDetails> builder(MarshallingType.SDK_POJO)
            .memberName("unusedIamUserPasswordDetails")
            .getter(getter(FindingDetails::unusedIamUserPasswordDetails))
            .setter(setter(Builder::unusedIamUserPasswordDetails))
            .constructor(UnusedIamUserPasswordDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedIamUserPasswordDetails")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERNAL_ACCESS_DETAILS_FIELD,
            EXTERNAL_ACCESS_DETAILS_FIELD, UNUSED_PERMISSION_DETAILS_FIELD, UNUSED_IAM_USER_ACCESS_KEY_DETAILS_FIELD,
            UNUSED_IAM_ROLE_DETAILS_FIELD, UNUSED_IAM_USER_PASSWORD_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InternalAccessDetails internalAccessDetails;

    private final ExternalAccessDetails externalAccessDetails;

    private final UnusedPermissionDetails unusedPermissionDetails;

    private final UnusedIamUserAccessKeyDetails unusedIamUserAccessKeyDetails;

    private final UnusedIamRoleDetails unusedIamRoleDetails;

    private final UnusedIamUserPasswordDetails unusedIamUserPasswordDetails;

    private final Type type;

    private FindingDetails(BuilderImpl builder) {
        this.internalAccessDetails = builder.internalAccessDetails;
        this.externalAccessDetails = builder.externalAccessDetails;
        this.unusedPermissionDetails = builder.unusedPermissionDetails;
        this.unusedIamUserAccessKeyDetails = builder.unusedIamUserAccessKeyDetails;
        this.unusedIamRoleDetails = builder.unusedIamRoleDetails;
        this.unusedIamUserPasswordDetails = builder.unusedIamUserPasswordDetails;
        this.type = builder.type;
    }

    /**
     * <p>
     * The details for an internal access analyzer finding. This contains information about access patterns identified
     * within your Amazon Web Services organization or account.
     * </p>
     * 
     * @return The details for an internal access analyzer finding. This contains information about access patterns
     *         identified within your Amazon Web Services organization or account.
     */
    public final InternalAccessDetails internalAccessDetails() {
        return internalAccessDetails;
    }

    /**
     * <p>
     * The details for an external access analyzer finding.
     * </p>
     * 
     * @return The details for an external access analyzer finding.
     */
    public final ExternalAccessDetails externalAccessDetails() {
        return externalAccessDetails;
    }

    /**
     * <p>
     * The details for an unused access analyzer finding with an unused permission finding type.
     * </p>
     * 
     * @return The details for an unused access analyzer finding with an unused permission finding type.
     */
    public final UnusedPermissionDetails unusedPermissionDetails() {
        return unusedPermissionDetails;
    }

    /**
     * <p>
     * The details for an unused access analyzer finding with an unused IAM user access key finding type.
     * </p>
     * 
     * @return The details for an unused access analyzer finding with an unused IAM user access key finding type.
     */
    public final UnusedIamUserAccessKeyDetails unusedIamUserAccessKeyDetails() {
        return unusedIamUserAccessKeyDetails;
    }

    /**
     * <p>
     * The details for an unused access analyzer finding with an unused IAM role finding type.
     * </p>
     * 
     * @return The details for an unused access analyzer finding with an unused IAM role finding type.
     */
    public final UnusedIamRoleDetails unusedIamRoleDetails() {
        return unusedIamRoleDetails;
    }

    /**
     * <p>
     * The details for an unused access analyzer finding with an unused IAM user password finding type.
     * </p>
     * 
     * @return The details for an unused access analyzer finding with an unused IAM user password finding type.
     */
    public final UnusedIamUserPasswordDetails unusedIamUserPasswordDetails() {
        return unusedIamUserPasswordDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(internalAccessDetails());
        hashCode = 31 * hashCode + Objects.hashCode(externalAccessDetails());
        hashCode = 31 * hashCode + Objects.hashCode(unusedPermissionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(unusedIamUserAccessKeyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(unusedIamRoleDetails());
        hashCode = 31 * hashCode + Objects.hashCode(unusedIamUserPasswordDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingDetails)) {
            return false;
        }
        FindingDetails other = (FindingDetails) obj;
        return Objects.equals(internalAccessDetails(), other.internalAccessDetails())
                && Objects.equals(externalAccessDetails(), other.externalAccessDetails())
                && Objects.equals(unusedPermissionDetails(), other.unusedPermissionDetails())
                && Objects.equals(unusedIamUserAccessKeyDetails(), other.unusedIamUserAccessKeyDetails())
                && Objects.equals(unusedIamRoleDetails(), other.unusedIamRoleDetails())
                && Objects.equals(unusedIamUserPasswordDetails(), other.unusedIamUserPasswordDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingDetails").add("InternalAccessDetails", internalAccessDetails())
                .add("ExternalAccessDetails", externalAccessDetails()).add("UnusedPermissionDetails", unusedPermissionDetails())
                .add("UnusedIamUserAccessKeyDetails", unusedIamUserAccessKeyDetails())
                .add("UnusedIamRoleDetails", unusedIamRoleDetails())
                .add("UnusedIamUserPasswordDetails", unusedIamUserPasswordDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "internalAccessDetails":
            return Optional.ofNullable(clazz.cast(internalAccessDetails()));
        case "externalAccessDetails":
            return Optional.ofNullable(clazz.cast(externalAccessDetails()));
        case "unusedPermissionDetails":
            return Optional.ofNullable(clazz.cast(unusedPermissionDetails()));
        case "unusedIamUserAccessKeyDetails":
            return Optional.ofNullable(clazz.cast(unusedIamUserAccessKeyDetails()));
        case "unusedIamRoleDetails":
            return Optional.ofNullable(clazz.cast(unusedIamRoleDetails()));
        case "unusedIamUserPasswordDetails":
            return Optional.ofNullable(clazz.cast(unusedIamUserPasswordDetails()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #internalAccessDetails()} initialized to the given value.
     *
     * <p>
     * The details for an internal access analyzer finding. This contains information about access patterns identified
     * within your Amazon Web Services organization or account.
     * </p>
     * 
     * @param internalAccessDetails
     *        The details for an internal access analyzer finding. This contains information about access patterns
     *        identified within your Amazon Web Services organization or account.
     */
    public static FindingDetails fromInternalAccessDetails(InternalAccessDetails internalAccessDetails) {
        return builder().internalAccessDetails(internalAccessDetails).build();
    }

    /**
     * Create an instance of this class with {@link #internalAccessDetails()} initialized to the given value.
     *
     * <p>
     * The details for an internal access analyzer finding. This contains information about access patterns identified
     * within your Amazon Web Services organization or account.
     * </p>
     * 
     * @param internalAccessDetails
     *        The details for an internal access analyzer finding. This contains information about access patterns
     *        identified within your Amazon Web Services organization or account.
     */
    public static FindingDetails fromInternalAccessDetails(Consumer<InternalAccessDetails.Builder> internalAccessDetails) {
        InternalAccessDetails.Builder builder = InternalAccessDetails.builder();
        internalAccessDetails.accept(builder);
        return fromInternalAccessDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #externalAccessDetails()} initialized to the given value.
     *
     * <p>
     * The details for an external access analyzer finding.
     * </p>
     * 
     * @param externalAccessDetails
     *        The details for an external access analyzer finding.
     */
    public static FindingDetails fromExternalAccessDetails(ExternalAccessDetails externalAccessDetails) {
        return builder().externalAccessDetails(externalAccessDetails).build();
    }

    /**
     * Create an instance of this class with {@link #externalAccessDetails()} initialized to the given value.
     *
     * <p>
     * The details for an external access analyzer finding.
     * </p>
     * 
     * @param externalAccessDetails
     *        The details for an external access analyzer finding.
     */
    public static FindingDetails fromExternalAccessDetails(Consumer<ExternalAccessDetails.Builder> externalAccessDetails) {
        ExternalAccessDetails.Builder builder = ExternalAccessDetails.builder();
        externalAccessDetails.accept(builder);
        return fromExternalAccessDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #unusedPermissionDetails()} initialized to the given value.
     *
     * <p>
     * The details for an unused access analyzer finding with an unused permission finding type.
     * </p>
     * 
     * @param unusedPermissionDetails
     *        The details for an unused access analyzer finding with an unused permission finding type.
     */
    public static FindingDetails fromUnusedPermissionDetails(UnusedPermissionDetails unusedPermissionDetails) {
        return builder().unusedPermissionDetails(unusedPermissionDetails).build();
    }

    /**
     * Create an instance of this class with {@link #unusedPermissionDetails()} initialized to the given value.
     *
     * <p>
     * The details for an unused access analyzer finding with an unused permission finding type.
     * </p>
     * 
     * @param unusedPermissionDetails
     *        The details for an unused access analyzer finding with an unused permission finding type.
     */
    public static FindingDetails fromUnusedPermissionDetails(Consumer<UnusedPermissionDetails.Builder> unusedPermissionDetails) {
        UnusedPermissionDetails.Builder builder = UnusedPermissionDetails.builder();
        unusedPermissionDetails.accept(builder);
        return fromUnusedPermissionDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #unusedIamUserAccessKeyDetails()} initialized to the given value.
     *
     * <p>
     * The details for an unused access analyzer finding with an unused IAM user access key finding type.
     * </p>
     * 
     * @param unusedIamUserAccessKeyDetails
     *        The details for an unused access analyzer finding with an unused IAM user access key finding type.
     */
    public static FindingDetails fromUnusedIamUserAccessKeyDetails(UnusedIamUserAccessKeyDetails unusedIamUserAccessKeyDetails) {
        return builder().unusedIamUserAccessKeyDetails(unusedIamUserAccessKeyDetails).build();
    }

    /**
     * Create an instance of this class with {@link #unusedIamUserAccessKeyDetails()} initialized to the given value.
     *
     * <p>
     * The details for an unused access analyzer finding with an unused IAM user access key finding type.
     * </p>
     * 
     * @param unusedIamUserAccessKeyDetails
     *        The details for an unused access analyzer finding with an unused IAM user access key finding type.
     */
    public static FindingDetails fromUnusedIamUserAccessKeyDetails(
            Consumer<UnusedIamUserAccessKeyDetails.Builder> unusedIamUserAccessKeyDetails) {
        UnusedIamUserAccessKeyDetails.Builder builder = UnusedIamUserAccessKeyDetails.builder();
        unusedIamUserAccessKeyDetails.accept(builder);
        return fromUnusedIamUserAccessKeyDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #unusedIamRoleDetails()} initialized to the given value.
     *
     * <p>
     * The details for an unused access analyzer finding with an unused IAM role finding type.
     * </p>
     * 
     * @param unusedIamRoleDetails
     *        The details for an unused access analyzer finding with an unused IAM role finding type.
     */
    public static FindingDetails fromUnusedIamRoleDetails(UnusedIamRoleDetails unusedIamRoleDetails) {
        return builder().unusedIamRoleDetails(unusedIamRoleDetails).build();
    }

    /**
     * Create an instance of this class with {@link #unusedIamRoleDetails()} initialized to the given value.
     *
     * <p>
     * The details for an unused access analyzer finding with an unused IAM role finding type.
     * </p>
     * 
     * @param unusedIamRoleDetails
     *        The details for an unused access analyzer finding with an unused IAM role finding type.
     */
    public static FindingDetails fromUnusedIamRoleDetails(Consumer<UnusedIamRoleDetails.Builder> unusedIamRoleDetails) {
        UnusedIamRoleDetails.Builder builder = UnusedIamRoleDetails.builder();
        unusedIamRoleDetails.accept(builder);
        return fromUnusedIamRoleDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #unusedIamUserPasswordDetails()} initialized to the given value.
     *
     * <p>
     * The details for an unused access analyzer finding with an unused IAM user password finding type.
     * </p>
     * 
     * @param unusedIamUserPasswordDetails
     *        The details for an unused access analyzer finding with an unused IAM user password finding type.
     */
    public static FindingDetails fromUnusedIamUserPasswordDetails(UnusedIamUserPasswordDetails unusedIamUserPasswordDetails) {
        return builder().unusedIamUserPasswordDetails(unusedIamUserPasswordDetails).build();
    }

    /**
     * Create an instance of this class with {@link #unusedIamUserPasswordDetails()} initialized to the given value.
     *
     * <p>
     * The details for an unused access analyzer finding with an unused IAM user password finding type.
     * </p>
     * 
     * @param unusedIamUserPasswordDetails
     *        The details for an unused access analyzer finding with an unused IAM user password finding type.
     */
    public static FindingDetails fromUnusedIamUserPasswordDetails(
            Consumer<UnusedIamUserPasswordDetails.Builder> unusedIamUserPasswordDetails) {
        UnusedIamUserPasswordDetails.Builder builder = UnusedIamUserPasswordDetails.builder();
        unusedIamUserPasswordDetails.accept(builder);
        return fromUnusedIamUserPasswordDetails(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("internalAccessDetails", INTERNAL_ACCESS_DETAILS_FIELD);
        map.put("externalAccessDetails", EXTERNAL_ACCESS_DETAILS_FIELD);
        map.put("unusedPermissionDetails", UNUSED_PERMISSION_DETAILS_FIELD);
        map.put("unusedIamUserAccessKeyDetails", UNUSED_IAM_USER_ACCESS_KEY_DETAILS_FIELD);
        map.put("unusedIamRoleDetails", UNUSED_IAM_ROLE_DETAILS_FIELD);
        map.put("unusedIamUserPasswordDetails", UNUSED_IAM_USER_PASSWORD_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingDetails, T> g) {
        return obj -> g.apply((FindingDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingDetails> {
        /**
         * <p>
         * The details for an internal access analyzer finding. This contains information about access patterns
         * identified within your Amazon Web Services organization or account.
         * </p>
         * 
         * @param internalAccessDetails
         *        The details for an internal access analyzer finding. This contains information about access patterns
         *        identified within your Amazon Web Services organization or account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internalAccessDetails(InternalAccessDetails internalAccessDetails);

        /**
         * <p>
         * The details for an internal access analyzer finding. This contains information about access patterns
         * identified within your Amazon Web Services organization or account.
         * </p>
         * This is a convenience method that creates an instance of the {@link InternalAccessDetails.Builder} avoiding
         * the need to create one manually via {@link InternalAccessDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InternalAccessDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #internalAccessDetails(InternalAccessDetails)}.
         * 
         * @param internalAccessDetails
         *        a consumer that will call methods on {@link InternalAccessDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #internalAccessDetails(InternalAccessDetails)
         */
        default Builder internalAccessDetails(Consumer<InternalAccessDetails.Builder> internalAccessDetails) {
            return internalAccessDetails(InternalAccessDetails.builder().applyMutation(internalAccessDetails).build());
        }

        /**
         * <p>
         * The details for an external access analyzer finding.
         * </p>
         * 
         * @param externalAccessDetails
         *        The details for an external access analyzer finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalAccessDetails(ExternalAccessDetails externalAccessDetails);

        /**
         * <p>
         * The details for an external access analyzer finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExternalAccessDetails.Builder} avoiding
         * the need to create one manually via {@link ExternalAccessDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalAccessDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #externalAccessDetails(ExternalAccessDetails)}.
         * 
         * @param externalAccessDetails
         *        a consumer that will call methods on {@link ExternalAccessDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalAccessDetails(ExternalAccessDetails)
         */
        default Builder externalAccessDetails(Consumer<ExternalAccessDetails.Builder> externalAccessDetails) {
            return externalAccessDetails(ExternalAccessDetails.builder().applyMutation(externalAccessDetails).build());
        }

        /**
         * <p>
         * The details for an unused access analyzer finding with an unused permission finding type.
         * </p>
         * 
         * @param unusedPermissionDetails
         *        The details for an unused access analyzer finding with an unused permission finding type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedPermissionDetails(UnusedPermissionDetails unusedPermissionDetails);

        /**
         * <p>
         * The details for an unused access analyzer finding with an unused permission finding type.
         * </p>
         * This is a convenience method that creates an instance of the {@link UnusedPermissionDetails.Builder} avoiding
         * the need to create one manually via {@link UnusedPermissionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnusedPermissionDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #unusedPermissionDetails(UnusedPermissionDetails)}.
         * 
         * @param unusedPermissionDetails
         *        a consumer that will call methods on {@link UnusedPermissionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unusedPermissionDetails(UnusedPermissionDetails)
         */
        default Builder unusedPermissionDetails(Consumer<UnusedPermissionDetails.Builder> unusedPermissionDetails) {
            return unusedPermissionDetails(UnusedPermissionDetails.builder().applyMutation(unusedPermissionDetails).build());
        }

        /**
         * <p>
         * The details for an unused access analyzer finding with an unused IAM user access key finding type.
         * </p>
         * 
         * @param unusedIamUserAccessKeyDetails
         *        The details for an unused access analyzer finding with an unused IAM user access key finding type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedIamUserAccessKeyDetails(UnusedIamUserAccessKeyDetails unusedIamUserAccessKeyDetails);

        /**
         * <p>
         * The details for an unused access analyzer finding with an unused IAM user access key finding type.
         * </p>
         * This is a convenience method that creates an instance of the {@link UnusedIamUserAccessKeyDetails.Builder}
         * avoiding the need to create one manually via {@link UnusedIamUserAccessKeyDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnusedIamUserAccessKeyDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #unusedIamUserAccessKeyDetails(UnusedIamUserAccessKeyDetails)}.
         * 
         * @param unusedIamUserAccessKeyDetails
         *        a consumer that will call methods on {@link UnusedIamUserAccessKeyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unusedIamUserAccessKeyDetails(UnusedIamUserAccessKeyDetails)
         */
        default Builder unusedIamUserAccessKeyDetails(
                Consumer<UnusedIamUserAccessKeyDetails.Builder> unusedIamUserAccessKeyDetails) {
            return unusedIamUserAccessKeyDetails(UnusedIamUserAccessKeyDetails.builder()
                    .applyMutation(unusedIamUserAccessKeyDetails).build());
        }

        /**
         * <p>
         * The details for an unused access analyzer finding with an unused IAM role finding type.
         * </p>
         * 
         * @param unusedIamRoleDetails
         *        The details for an unused access analyzer finding with an unused IAM role finding type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedIamRoleDetails(UnusedIamRoleDetails unusedIamRoleDetails);

        /**
         * <p>
         * The details for an unused access analyzer finding with an unused IAM role finding type.
         * </p>
         * This is a convenience method that creates an instance of the {@link UnusedIamRoleDetails.Builder} avoiding
         * the need to create one manually via {@link UnusedIamRoleDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnusedIamRoleDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #unusedIamRoleDetails(UnusedIamRoleDetails)}.
         * 
         * @param unusedIamRoleDetails
         *        a consumer that will call methods on {@link UnusedIamRoleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unusedIamRoleDetails(UnusedIamRoleDetails)
         */
        default Builder unusedIamRoleDetails(Consumer<UnusedIamRoleDetails.Builder> unusedIamRoleDetails) {
            return unusedIamRoleDetails(UnusedIamRoleDetails.builder().applyMutation(unusedIamRoleDetails).build());
        }

        /**
         * <p>
         * The details for an unused access analyzer finding with an unused IAM user password finding type.
         * </p>
         * 
         * @param unusedIamUserPasswordDetails
         *        The details for an unused access analyzer finding with an unused IAM user password finding type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedIamUserPasswordDetails(UnusedIamUserPasswordDetails unusedIamUserPasswordDetails);

        /**
         * <p>
         * The details for an unused access analyzer finding with an unused IAM user password finding type.
         * </p>
         * This is a convenience method that creates an instance of the {@link UnusedIamUserPasswordDetails.Builder}
         * avoiding the need to create one manually via {@link UnusedIamUserPasswordDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnusedIamUserPasswordDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #unusedIamUserPasswordDetails(UnusedIamUserPasswordDetails)}.
         * 
         * @param unusedIamUserPasswordDetails
         *        a consumer that will call methods on {@link UnusedIamUserPasswordDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unusedIamUserPasswordDetails(UnusedIamUserPasswordDetails)
         */
        default Builder unusedIamUserPasswordDetails(Consumer<UnusedIamUserPasswordDetails.Builder> unusedIamUserPasswordDetails) {
            return unusedIamUserPasswordDetails(UnusedIamUserPasswordDetails.builder()
                    .applyMutation(unusedIamUserPasswordDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InternalAccessDetails internalAccessDetails;

        private ExternalAccessDetails externalAccessDetails;

        private UnusedPermissionDetails unusedPermissionDetails;

        private UnusedIamUserAccessKeyDetails unusedIamUserAccessKeyDetails;

        private UnusedIamRoleDetails unusedIamRoleDetails;

        private UnusedIamUserPasswordDetails unusedIamUserPasswordDetails;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FindingDetails model) {
            internalAccessDetails(model.internalAccessDetails);
            externalAccessDetails(model.externalAccessDetails);
            unusedPermissionDetails(model.unusedPermissionDetails);
            unusedIamUserAccessKeyDetails(model.unusedIamUserAccessKeyDetails);
            unusedIamRoleDetails(model.unusedIamRoleDetails);
            unusedIamUserPasswordDetails(model.unusedIamUserPasswordDetails);
        }

        public final InternalAccessDetails.Builder getInternalAccessDetails() {
            return internalAccessDetails != null ? internalAccessDetails.toBuilder() : null;
        }

        public final void setInternalAccessDetails(InternalAccessDetails.BuilderImpl internalAccessDetails) {
            Object oldValue = this.internalAccessDetails;
            this.internalAccessDetails = internalAccessDetails != null ? internalAccessDetails.build() : null;
            handleUnionValueChange(Type.INTERNAL_ACCESS_DETAILS, oldValue, this.internalAccessDetails);
        }

        @Override
        public final Builder internalAccessDetails(InternalAccessDetails internalAccessDetails) {
            Object oldValue = this.internalAccessDetails;
            this.internalAccessDetails = internalAccessDetails;
            handleUnionValueChange(Type.INTERNAL_ACCESS_DETAILS, oldValue, this.internalAccessDetails);
            return this;
        }

        public final ExternalAccessDetails.Builder getExternalAccessDetails() {
            return externalAccessDetails != null ? externalAccessDetails.toBuilder() : null;
        }

        public final void setExternalAccessDetails(ExternalAccessDetails.BuilderImpl externalAccessDetails) {
            Object oldValue = this.externalAccessDetails;
            this.externalAccessDetails = externalAccessDetails != null ? externalAccessDetails.build() : null;
            handleUnionValueChange(Type.EXTERNAL_ACCESS_DETAILS, oldValue, this.externalAccessDetails);
        }

        @Override
        public final Builder externalAccessDetails(ExternalAccessDetails externalAccessDetails) {
            Object oldValue = this.externalAccessDetails;
            this.externalAccessDetails = externalAccessDetails;
            handleUnionValueChange(Type.EXTERNAL_ACCESS_DETAILS, oldValue, this.externalAccessDetails);
            return this;
        }

        public final UnusedPermissionDetails.Builder getUnusedPermissionDetails() {
            return unusedPermissionDetails != null ? unusedPermissionDetails.toBuilder() : null;
        }

        public final void setUnusedPermissionDetails(UnusedPermissionDetails.BuilderImpl unusedPermissionDetails) {
            Object oldValue = this.unusedPermissionDetails;
            this.unusedPermissionDetails = unusedPermissionDetails != null ? unusedPermissionDetails.build() : null;
            handleUnionValueChange(Type.UNUSED_PERMISSION_DETAILS, oldValue, this.unusedPermissionDetails);
        }

        @Override
        public final Builder unusedPermissionDetails(UnusedPermissionDetails unusedPermissionDetails) {
            Object oldValue = this.unusedPermissionDetails;
            this.unusedPermissionDetails = unusedPermissionDetails;
            handleUnionValueChange(Type.UNUSED_PERMISSION_DETAILS, oldValue, this.unusedPermissionDetails);
            return this;
        }

        public final UnusedIamUserAccessKeyDetails.Builder getUnusedIamUserAccessKeyDetails() {
            return unusedIamUserAccessKeyDetails != null ? unusedIamUserAccessKeyDetails.toBuilder() : null;
        }

        public final void setUnusedIamUserAccessKeyDetails(UnusedIamUserAccessKeyDetails.BuilderImpl unusedIamUserAccessKeyDetails) {
            Object oldValue = this.unusedIamUserAccessKeyDetails;
            this.unusedIamUserAccessKeyDetails = unusedIamUserAccessKeyDetails != null ? unusedIamUserAccessKeyDetails.build()
                    : null;
            handleUnionValueChange(Type.UNUSED_IAM_USER_ACCESS_KEY_DETAILS, oldValue, this.unusedIamUserAccessKeyDetails);
        }

        @Override
        public final Builder unusedIamUserAccessKeyDetails(UnusedIamUserAccessKeyDetails unusedIamUserAccessKeyDetails) {
            Object oldValue = this.unusedIamUserAccessKeyDetails;
            this.unusedIamUserAccessKeyDetails = unusedIamUserAccessKeyDetails;
            handleUnionValueChange(Type.UNUSED_IAM_USER_ACCESS_KEY_DETAILS, oldValue, this.unusedIamUserAccessKeyDetails);
            return this;
        }

        public final UnusedIamRoleDetails.Builder getUnusedIamRoleDetails() {
            return unusedIamRoleDetails != null ? unusedIamRoleDetails.toBuilder() : null;
        }

        public final void setUnusedIamRoleDetails(UnusedIamRoleDetails.BuilderImpl unusedIamRoleDetails) {
            Object oldValue = this.unusedIamRoleDetails;
            this.unusedIamRoleDetails = unusedIamRoleDetails != null ? unusedIamRoleDetails.build() : null;
            handleUnionValueChange(Type.UNUSED_IAM_ROLE_DETAILS, oldValue, this.unusedIamRoleDetails);
        }

        @Override
        public final Builder unusedIamRoleDetails(UnusedIamRoleDetails unusedIamRoleDetails) {
            Object oldValue = this.unusedIamRoleDetails;
            this.unusedIamRoleDetails = unusedIamRoleDetails;
            handleUnionValueChange(Type.UNUSED_IAM_ROLE_DETAILS, oldValue, this.unusedIamRoleDetails);
            return this;
        }

        public final UnusedIamUserPasswordDetails.Builder getUnusedIamUserPasswordDetails() {
            return unusedIamUserPasswordDetails != null ? unusedIamUserPasswordDetails.toBuilder() : null;
        }

        public final void setUnusedIamUserPasswordDetails(UnusedIamUserPasswordDetails.BuilderImpl unusedIamUserPasswordDetails) {
            Object oldValue = this.unusedIamUserPasswordDetails;
            this.unusedIamUserPasswordDetails = unusedIamUserPasswordDetails != null ? unusedIamUserPasswordDetails.build()
                    : null;
            handleUnionValueChange(Type.UNUSED_IAM_USER_PASSWORD_DETAILS, oldValue, this.unusedIamUserPasswordDetails);
        }

        @Override
        public final Builder unusedIamUserPasswordDetails(UnusedIamUserPasswordDetails unusedIamUserPasswordDetails) {
            Object oldValue = this.unusedIamUserPasswordDetails;
            this.unusedIamUserPasswordDetails = unusedIamUserPasswordDetails;
            handleUnionValueChange(Type.UNUSED_IAM_USER_PASSWORD_DETAILS, oldValue, this.unusedIamUserPasswordDetails);
            return this;
        }

        @Override
        public FindingDetails build() {
            return new FindingDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FindingDetails#type()
     */
    public enum Type {
        INTERNAL_ACCESS_DETAILS,

        EXTERNAL_ACCESS_DETAILS,

        UNUSED_PERMISSION_DETAILS,

        UNUSED_IAM_USER_ACCESS_KEY_DETAILS,

        UNUSED_IAM_ROLE_DETAILS,

        UNUSED_IAM_USER_PASSWORD_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
