/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckNoPublicAccessRequest extends AccessAnalyzerRequest implements
        ToCopyableBuilder<CheckNoPublicAccessRequest.Builder, CheckNoPublicAccessRequest> {
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyDocument").getter(getter(CheckNoPublicAccessRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(CheckNoPublicAccessRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_DOCUMENT_FIELD,
            RESOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyDocument;

    private final String resourceType;

    private CheckNoPublicAccessRequest(BuilderImpl builder) {
        super(builder);
        this.policyDocument = builder.policyDocument;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The JSON policy document to evaluate for public access.
     * </p>
     * 
     * @return The JSON policy document to evaluate for public access.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * The type of resource to evaluate for public access. For example, to check for public access to Amazon S3 buckets,
     * you can choose <code>AWS::S3::Bucket</code> for the resource type.
     * </p>
     * <p>
     * For resource types not supported as valid values, IAM Access Analyzer will return an error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link AccessCheckResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource to evaluate for public access. For example, to check for public access to Amazon S3
     *         buckets, you can choose <code>AWS::S3::Bucket</code> for the resource type.</p>
     *         <p>
     *         For resource types not supported as valid values, IAM Access Analyzer will return an error.
     * @see AccessCheckResourceType
     */
    public final AccessCheckResourceType resourceType() {
        return AccessCheckResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource to evaluate for public access. For example, to check for public access to Amazon S3 buckets,
     * you can choose <code>AWS::S3::Bucket</code> for the resource type.
     * </p>
     * <p>
     * For resource types not supported as valid values, IAM Access Analyzer will return an error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link AccessCheckResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource to evaluate for public access. For example, to check for public access to Amazon S3
     *         buckets, you can choose <code>AWS::S3::Bucket</code> for the resource type.</p>
     *         <p>
     *         For resource types not supported as valid values, IAM Access Analyzer will return an error.
     * @see AccessCheckResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckNoPublicAccessRequest)) {
            return false;
        }
        CheckNoPublicAccessRequest other = (CheckNoPublicAccessRequest) obj;
        return Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckNoPublicAccessRequest")
                .add("PolicyDocument", policyDocument() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ResourceType", resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckNoPublicAccessRequest, T> g) {
        return obj -> g.apply((CheckNoPublicAccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AccessAnalyzerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CheckNoPublicAccessRequest> {
        /**
         * <p>
         * The JSON policy document to evaluate for public access.
         * </p>
         * 
         * @param policyDocument
         *        The JSON policy document to evaluate for public access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * The type of resource to evaluate for public access. For example, to check for public access to Amazon S3
         * buckets, you can choose <code>AWS::S3::Bucket</code> for the resource type.
         * </p>
         * <p>
         * For resource types not supported as valid values, IAM Access Analyzer will return an error.
         * </p>
         * 
         * @param resourceType
         *        The type of resource to evaluate for public access. For example, to check for public access to Amazon
         *        S3 buckets, you can choose <code>AWS::S3::Bucket</code> for the resource type.</p>
         *        <p>
         *        For resource types not supported as valid values, IAM Access Analyzer will return an error.
         * @see AccessCheckResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessCheckResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource to evaluate for public access. For example, to check for public access to Amazon S3
         * buckets, you can choose <code>AWS::S3::Bucket</code> for the resource type.
         * </p>
         * <p>
         * For resource types not supported as valid values, IAM Access Analyzer will return an error.
         * </p>
         * 
         * @param resourceType
         *        The type of resource to evaluate for public access. For example, to check for public access to Amazon
         *        S3 buckets, you can choose <code>AWS::S3::Bucket</code> for the resource type.</p>
         *        <p>
         *        For resource types not supported as valid values, IAM Access Analyzer will return an error.
         * @see AccessCheckResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessCheckResourceType
         */
        Builder resourceType(AccessCheckResourceType resourceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccessAnalyzerRequest.BuilderImpl implements Builder {
        private String policyDocument;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckNoPublicAccessRequest model) {
            super(model);
            policyDocument(model.policyDocument);
            resourceType(model.resourceType);
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(AccessCheckResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckNoPublicAccessRequest build() {
            return new CheckNoPublicAccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
