/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckNoNewAccessRequest extends AccessAnalyzerRequest implements
        ToCopyableBuilder<CheckNoNewAccessRequest.Builder, CheckNoNewAccessRequest> {
    private static final SdkField<String> NEW_POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("newPolicyDocument").getter(getter(CheckNoNewAccessRequest::newPolicyDocument))
            .setter(setter(Builder::newPolicyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newPolicyDocument").build()).build();

    private static final SdkField<String> EXISTING_POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("existingPolicyDocument").getter(getter(CheckNoNewAccessRequest::existingPolicyDocument))
            .setter(setter(Builder::existingPolicyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("existingPolicyDocument").build())
            .build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyType").getter(getter(CheckNoNewAccessRequest::policyTypeAsString))
            .setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEW_POLICY_DOCUMENT_FIELD,
            EXISTING_POLICY_DOCUMENT_FIELD, POLICY_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String newPolicyDocument;

    private final String existingPolicyDocument;

    private final String policyType;

    private CheckNoNewAccessRequest(BuilderImpl builder) {
        super(builder);
        this.newPolicyDocument = builder.newPolicyDocument;
        this.existingPolicyDocument = builder.existingPolicyDocument;
        this.policyType = builder.policyType;
    }

    /**
     * <p>
     * The JSON policy document to use as the content for the updated policy.
     * </p>
     * 
     * @return The JSON policy document to use as the content for the updated policy.
     */
    public final String newPolicyDocument() {
        return newPolicyDocument;
    }

    /**
     * <p>
     * The JSON policy document to use as the content for the existing policy.
     * </p>
     * 
     * @return The JSON policy document to use as the content for the existing policy.
     */
    public final String existingPolicyDocument() {
        return existingPolicyDocument;
    }

    /**
     * <p>
     * The type of policy to compare. Identity policies grant permissions to IAM principals. Identity policies include
     * managed and inline policies for IAM roles, users, and groups.
     * </p>
     * <p>
     * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust policies
     * for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as identity policy
     * or resource policy or a specific input such as managed policy or Amazon S3 bucket policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link AccessCheckPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy to compare. Identity policies grant permissions to IAM principals. Identity policies
     *         include managed and inline policies for IAM roles, users, and groups.</p>
     *         <p>
     *         Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
     *         policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as
     *         identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy.
     * @see AccessCheckPolicyType
     */
    public final AccessCheckPolicyType policyType() {
        return AccessCheckPolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The type of policy to compare. Identity policies grant permissions to IAM principals. Identity policies include
     * managed and inline policies for IAM roles, users, and groups.
     * </p>
     * <p>
     * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust policies
     * for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as identity policy
     * or resource policy or a specific input such as managed policy or Amazon S3 bucket policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link AccessCheckPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy to compare. Identity policies grant permissions to IAM principals. Identity policies
     *         include managed and inline policies for IAM roles, users, and groups.</p>
     *         <p>
     *         Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
     *         policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as
     *         identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy.
     * @see AccessCheckPolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(newPolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(existingPolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckNoNewAccessRequest)) {
            return false;
        }
        CheckNoNewAccessRequest other = (CheckNoNewAccessRequest) obj;
        return Objects.equals(newPolicyDocument(), other.newPolicyDocument())
                && Objects.equals(existingPolicyDocument(), other.existingPolicyDocument())
                && Objects.equals(policyTypeAsString(), other.policyTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckNoNewAccessRequest")
                .add("NewPolicyDocument", newPolicyDocument() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExistingPolicyDocument", existingPolicyDocument() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PolicyType", policyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "newPolicyDocument":
            return Optional.ofNullable(clazz.cast(newPolicyDocument()));
        case "existingPolicyDocument":
            return Optional.ofNullable(clazz.cast(existingPolicyDocument()));
        case "policyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("newPolicyDocument", NEW_POLICY_DOCUMENT_FIELD);
        map.put("existingPolicyDocument", EXISTING_POLICY_DOCUMENT_FIELD);
        map.put("policyType", POLICY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckNoNewAccessRequest, T> g) {
        return obj -> g.apply((CheckNoNewAccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AccessAnalyzerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CheckNoNewAccessRequest> {
        /**
         * <p>
         * The JSON policy document to use as the content for the updated policy.
         * </p>
         * 
         * @param newPolicyDocument
         *        The JSON policy document to use as the content for the updated policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newPolicyDocument(String newPolicyDocument);

        /**
         * <p>
         * The JSON policy document to use as the content for the existing policy.
         * </p>
         * 
         * @param existingPolicyDocument
         *        The JSON policy document to use as the content for the existing policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder existingPolicyDocument(String existingPolicyDocument);

        /**
         * <p>
         * The type of policy to compare. Identity policies grant permissions to IAM principals. Identity policies
         * include managed and inline policies for IAM roles, users, and groups.
         * </p>
         * <p>
         * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
         * policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as
         * identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy.
         * </p>
         * 
         * @param policyType
         *        The type of policy to compare. Identity policies grant permissions to IAM principals. Identity
         *        policies include managed and inline policies for IAM roles, users, and groups.</p>
         *        <p>
         *        Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
         *        policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such
         *        as identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket
         *        policy.
         * @see AccessCheckPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessCheckPolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The type of policy to compare. Identity policies grant permissions to IAM principals. Identity policies
         * include managed and inline policies for IAM roles, users, and groups.
         * </p>
         * <p>
         * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
         * policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as
         * identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy.
         * </p>
         * 
         * @param policyType
         *        The type of policy to compare. Identity policies grant permissions to IAM principals. Identity
         *        policies include managed and inline policies for IAM roles, users, and groups.</p>
         *        <p>
         *        Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
         *        policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such
         *        as identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket
         *        policy.
         * @see AccessCheckPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessCheckPolicyType
         */
        Builder policyType(AccessCheckPolicyType policyType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccessAnalyzerRequest.BuilderImpl implements Builder {
        private String newPolicyDocument;

        private String existingPolicyDocument;

        private String policyType;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckNoNewAccessRequest model) {
            super(model);
            newPolicyDocument(model.newPolicyDocument);
            existingPolicyDocument(model.existingPolicyDocument);
            policyType(model.policyType);
        }

        public final String getNewPolicyDocument() {
            return newPolicyDocument;
        }

        public final void setNewPolicyDocument(String newPolicyDocument) {
            this.newPolicyDocument = newPolicyDocument;
        }

        @Override
        public final Builder newPolicyDocument(String newPolicyDocument) {
            this.newPolicyDocument = newPolicyDocument;
            return this;
        }

        public final String getExistingPolicyDocument() {
            return existingPolicyDocument;
        }

        public final void setExistingPolicyDocument(String existingPolicyDocument) {
            this.existingPolicyDocument = existingPolicyDocument;
        }

        @Override
        public final Builder existingPolicyDocument(String existingPolicyDocument) {
            this.existingPolicyDocument = existingPolicyDocument;
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(AccessCheckPolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckNoNewAccessRequest build() {
            return new CheckNoNewAccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
