/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckAccessNotGrantedRequest extends AccessAnalyzerRequest implements
        ToCopyableBuilder<CheckAccessNotGrantedRequest.Builder, CheckAccessNotGrantedRequest> {
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyDocument").getter(getter(CheckAccessNotGrantedRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()).build();

    private static final SdkField<List<Access>> ACCESS_FIELD = SdkField
            .<List<Access>> builder(MarshallingType.LIST)
            .memberName("access")
            .getter(getter(CheckAccessNotGrantedRequest::access))
            .setter(setter(Builder::access))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("access").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Access> builder(MarshallingType.SDK_POJO)
                                            .constructor(Access::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyType").getter(getter(CheckAccessNotGrantedRequest::policyTypeAsString))
            .setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_DOCUMENT_FIELD,
            ACCESS_FIELD, POLICY_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyDocument;

    private final List<Access> access;

    private final String policyType;

    private CheckAccessNotGrantedRequest(BuilderImpl builder) {
        super(builder);
        this.policyDocument = builder.policyDocument;
        this.access = builder.access;
        this.policyType = builder.policyType;
    }

    /**
     * <p>
     * The JSON policy document to use as the content for the policy.
     * </p>
     * 
     * @return The JSON policy document to use as the content for the policy.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * For responses, this returns true if the service returned a value for the Access property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccess() {
        return access != null && !(access instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An access object containing the permissions that shouldn't be granted by the specified policy. If only actions
     * are specified, IAM Access Analyzer checks for access to peform at least one of the actions on any resource in the
     * policy. If only resources are specified, then IAM Access Analyzer checks for access to perform any action on at
     * least one of the resources. If both actions and resources are specified, IAM Access Analyzer checks for access to
     * perform at least one of the specified actions on at least one of the specified resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccess} method.
     * </p>
     * 
     * @return An access object containing the permissions that shouldn't be granted by the specified policy. If only
     *         actions are specified, IAM Access Analyzer checks for access to peform at least one of the actions on any
     *         resource in the policy. If only resources are specified, then IAM Access Analyzer checks for access to
     *         perform any action on at least one of the resources. If both actions and resources are specified, IAM
     *         Access Analyzer checks for access to perform at least one of the specified actions on at least one of the
     *         specified resources.
     */
    public final List<Access> access() {
        return access;
    }

    /**
     * <p>
     * The type of policy. Identity policies grant permissions to IAM principals. Identity policies include managed and
     * inline policies for IAM roles, users, and groups.
     * </p>
     * <p>
     * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust policies
     * for IAM roles and bucket policies for Amazon S3 buckets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link AccessCheckPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy. Identity policies grant permissions to IAM principals. Identity policies include
     *         managed and inline policies for IAM roles, users, and groups.</p>
     *         <p>
     *         Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
     *         policies for IAM roles and bucket policies for Amazon S3 buckets.
     * @see AccessCheckPolicyType
     */
    public final AccessCheckPolicyType policyType() {
        return AccessCheckPolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The type of policy. Identity policies grant permissions to IAM principals. Identity policies include managed and
     * inline policies for IAM roles, users, and groups.
     * </p>
     * <p>
     * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust policies
     * for IAM roles and bucket policies for Amazon S3 buckets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link AccessCheckPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy. Identity policies grant permissions to IAM principals. Identity policies include
     *         managed and inline policies for IAM roles, users, and groups.</p>
     *         <p>
     *         Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
     *         policies for IAM roles and bucket policies for Amazon S3 buckets.
     * @see AccessCheckPolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccess() ? access() : null);
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckAccessNotGrantedRequest)) {
            return false;
        }
        CheckAccessNotGrantedRequest other = (CheckAccessNotGrantedRequest) obj;
        return Objects.equals(policyDocument(), other.policyDocument()) && hasAccess() == other.hasAccess()
                && Objects.equals(access(), other.access()) && Objects.equals(policyTypeAsString(), other.policyTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckAccessNotGrantedRequest")
                .add("PolicyDocument", policyDocument() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Access", hasAccess() ? access() : null).add("PolicyType", policyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "access":
            return Optional.ofNullable(clazz.cast(access()));
        case "policyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        map.put("access", ACCESS_FIELD);
        map.put("policyType", POLICY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckAccessNotGrantedRequest, T> g) {
        return obj -> g.apply((CheckAccessNotGrantedRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AccessAnalyzerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CheckAccessNotGrantedRequest> {
        /**
         * <p>
         * The JSON policy document to use as the content for the policy.
         * </p>
         * 
         * @param policyDocument
         *        The JSON policy document to use as the content for the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * An access object containing the permissions that shouldn't be granted by the specified policy. If only
         * actions are specified, IAM Access Analyzer checks for access to peform at least one of the actions on any
         * resource in the policy. If only resources are specified, then IAM Access Analyzer checks for access to
         * perform any action on at least one of the resources. If both actions and resources are specified, IAM Access
         * Analyzer checks for access to perform at least one of the specified actions on at least one of the specified
         * resources.
         * </p>
         * 
         * @param access
         *        An access object containing the permissions that shouldn't be granted by the specified policy. If only
         *        actions are specified, IAM Access Analyzer checks for access to peform at least one of the actions on
         *        any resource in the policy. If only resources are specified, then IAM Access Analyzer checks for
         *        access to perform any action on at least one of the resources. If both actions and resources are
         *        specified, IAM Access Analyzer checks for access to perform at least one of the specified actions on
         *        at least one of the specified resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder access(Collection<Access> access);

        /**
         * <p>
         * An access object containing the permissions that shouldn't be granted by the specified policy. If only
         * actions are specified, IAM Access Analyzer checks for access to peform at least one of the actions on any
         * resource in the policy. If only resources are specified, then IAM Access Analyzer checks for access to
         * perform any action on at least one of the resources. If both actions and resources are specified, IAM Access
         * Analyzer checks for access to perform at least one of the specified actions on at least one of the specified
         * resources.
         * </p>
         * 
         * @param access
         *        An access object containing the permissions that shouldn't be granted by the specified policy. If only
         *        actions are specified, IAM Access Analyzer checks for access to peform at least one of the actions on
         *        any resource in the policy. If only resources are specified, then IAM Access Analyzer checks for
         *        access to perform any action on at least one of the resources. If both actions and resources are
         *        specified, IAM Access Analyzer checks for access to perform at least one of the specified actions on
         *        at least one of the specified resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder access(Access... access);

        /**
         * <p>
         * An access object containing the permissions that shouldn't be granted by the specified policy. If only
         * actions are specified, IAM Access Analyzer checks for access to peform at least one of the actions on any
         * resource in the policy. If only resources are specified, then IAM Access Analyzer checks for access to
         * perform any action on at least one of the resources. If both actions and resources are specified, IAM Access
         * Analyzer checks for access to perform at least one of the specified actions on at least one of the specified
         * resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.accessanalyzer.model.Access.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.accessanalyzer.model.Access#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.accessanalyzer.model.Access.Builder#build()} is called immediately and
         * its result is passed to {@link #access(List<Access>)}.
         * 
         * @param access
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.accessanalyzer.model.Access.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #access(java.util.Collection<Access>)
         */
        Builder access(Consumer<Access.Builder>... access);

        /**
         * <p>
         * The type of policy. Identity policies grant permissions to IAM principals. Identity policies include managed
         * and inline policies for IAM roles, users, and groups.
         * </p>
         * <p>
         * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
         * policies for IAM roles and bucket policies for Amazon S3 buckets.
         * </p>
         * 
         * @param policyType
         *        The type of policy. Identity policies grant permissions to IAM principals. Identity policies include
         *        managed and inline policies for IAM roles, users, and groups.</p>
         *        <p>
         *        Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
         *        policies for IAM roles and bucket policies for Amazon S3 buckets.
         * @see AccessCheckPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessCheckPolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The type of policy. Identity policies grant permissions to IAM principals. Identity policies include managed
         * and inline policies for IAM roles, users, and groups.
         * </p>
         * <p>
         * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
         * policies for IAM roles and bucket policies for Amazon S3 buckets.
         * </p>
         * 
         * @param policyType
         *        The type of policy. Identity policies grant permissions to IAM principals. Identity policies include
         *        managed and inline policies for IAM roles, users, and groups.</p>
         *        <p>
         *        Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
         *        policies for IAM roles and bucket policies for Amazon S3 buckets.
         * @see AccessCheckPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessCheckPolicyType
         */
        Builder policyType(AccessCheckPolicyType policyType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccessAnalyzerRequest.BuilderImpl implements Builder {
        private String policyDocument;

        private List<Access> access = DefaultSdkAutoConstructList.getInstance();

        private String policyType;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckAccessNotGrantedRequest model) {
            super(model);
            policyDocument(model.policyDocument);
            access(model.access);
            policyType(model.policyType);
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final List<Access.Builder> getAccess() {
            List<Access.Builder> result = CheckAccessNotGrantedRequestAccessListCopier.copyToBuilder(this.access);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccess(Collection<Access.BuilderImpl> access) {
            this.access = CheckAccessNotGrantedRequestAccessListCopier.copyFromBuilder(access);
        }

        @Override
        public final Builder access(Collection<Access> access) {
            this.access = CheckAccessNotGrantedRequestAccessListCopier.copy(access);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder access(Access... access) {
            access(Arrays.asList(access));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder access(Consumer<Access.Builder>... access) {
            access(Stream.of(access).map(c -> Access.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(AccessCheckPolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckAccessNotGrantedRequest build() {
            return new CheckAccessNotGrantedRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
