/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.ActionListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.ConditionKeyMapCopier;
import software.amazon.awssdk.services.accessanalyzer.model.FindingSource;
import software.amazon.awssdk.services.accessanalyzer.model.FindingSourceListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.FindingStatus;
import software.amazon.awssdk.services.accessanalyzer.model.PrincipalMapCopier;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceControlPolicyRestriction;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(FindingSummary.getter(FindingSummary::id)).setter(FindingSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Map<String, String>> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("principal").getter(FindingSummary.getter(FindingSummary::principal)).setter(FindingSummary.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("action").getter(FindingSummary.getter(FindingSummary::action)).setter(FindingSummary.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resource").getter(FindingSummary.getter(FindingSummary::resource)).setter(FindingSummary.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<Boolean> IS_PUBLIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isPublic").getter(FindingSummary.getter(FindingSummary::isPublic)).setter(FindingSummary.setter(Builder::isPublic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPublic").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(FindingSummary.getter(FindingSummary::resourceTypeAsString)).setter(FindingSummary.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<Map<String, String>> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("condition").getter(FindingSummary.getter(FindingSummary::condition)).setter(FindingSummary.setter(Builder::condition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(FindingSummary.getter(FindingSummary::createdAt)).setter(FindingSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ANALYZED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("analyzedAt").getter(FindingSummary.getter(FindingSummary::analyzedAt)).setter(FindingSummary.setter(Builder::analyzedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(FindingSummary.getter(FindingSummary::updatedAt)).setter(FindingSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(FindingSummary.getter(FindingSummary::statusAsString)).setter(FindingSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceOwnerAccount").getter(FindingSummary.getter(FindingSummary::resourceOwnerAccount)).setter(FindingSummary.setter(Builder::resourceOwnerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwnerAccount").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("error").getter(FindingSummary.getter(FindingSummary::error)).setter(FindingSummary.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<List<FindingSource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(FindingSummary.getter(FindingSummary::sources)).setter(FindingSummary.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_CONTROL_POLICY_RESTRICTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceControlPolicyRestriction").getter(FindingSummary.getter(FindingSummary::resourceControlPolicyRestrictionAsString)).setter(FindingSummary.setter(Builder::resourceControlPolicyRestriction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceControlPolicyRestriction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PRINCIPAL_FIELD, ACTION_FIELD, RESOURCE_FIELD, IS_PUBLIC_FIELD, RESOURCE_TYPE_FIELD, CONDITION_FIELD, CREATED_AT_FIELD, ANALYZED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD, RESOURCE_OWNER_ACCOUNT_FIELD, ERROR_FIELD, SOURCES_FIELD, RESOURCE_CONTROL_POLICY_RESTRICTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FindingSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Map<String, String> principal;
    private final List<String> action;
    private final String resource;
    private final Boolean isPublic;
    private final String resourceType;
    private final Map<String, String> condition;
    private final Instant createdAt;
    private final Instant analyzedAt;
    private final Instant updatedAt;
    private final String status;
    private final String resourceOwnerAccount;
    private final String error;
    private final List<FindingSource> sources;
    private final String resourceControlPolicyRestriction;

    private FindingSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.principal = builder.principal;
        this.action = builder.action;
        this.resource = builder.resource;
        this.isPublic = builder.isPublic;
        this.resourceType = builder.resourceType;
        this.condition = builder.condition;
        this.createdAt = builder.createdAt;
        this.analyzedAt = builder.analyzedAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.error = builder.error;
        this.sources = builder.sources;
        this.resourceControlPolicyRestriction = builder.resourceControlPolicyRestriction;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasPrincipal() {
        return this.principal != null && !(this.principal instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> principal() {
        return this.principal;
    }

    public final boolean hasAction() {
        return this.action != null && !(this.action instanceof SdkAutoConstructList);
    }

    public final List<String> action() {
        return this.action;
    }

    public final String resource() {
        return this.resource;
    }

    public final Boolean isPublic() {
        return this.isPublic;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasCondition() {
        return this.condition != null && !(this.condition instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> condition() {
        return this.condition;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant analyzedAt() {
        return this.analyzedAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final FindingStatus status() {
        return FindingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String resourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public final String error() {
        return this.error;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<FindingSource> sources() {
        return this.sources;
    }

    public final ResourceControlPolicyRestriction resourceControlPolicyRestriction() {
        return ResourceControlPolicyRestriction.fromValue(this.resourceControlPolicyRestriction);
    }

    public final String resourceControlPolicyRestrictionAsString() {
        return this.resourceControlPolicyRestriction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipal() ? this.principal() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAction() ? this.action() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPublic());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCondition() ? this.condition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceControlPolicyRestrictionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingSummary)) {
            return false;
        }
        FindingSummary other = (FindingSummary)obj;
        return Objects.equals(this.id(), other.id()) && this.hasPrincipal() == other.hasPrincipal() && Objects.equals(this.principal(), other.principal()) && this.hasAction() == other.hasAction() && Objects.equals(this.action(), other.action()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.isPublic(), other.isPublic()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasCondition() == other.hasCondition() && Objects.equals(this.condition(), other.condition()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.analyzedAt(), other.analyzedAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.resourceOwnerAccount(), other.resourceOwnerAccount()) && Objects.equals(this.error(), other.error()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.resourceControlPolicyRestrictionAsString(), other.resourceControlPolicyRestrictionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FindingSummary").add("Id", (Object)this.id()).add("Principal", this.hasPrincipal() ? this.principal() : null).add("Action", this.hasAction() ? this.action() : null).add("Resource", (Object)this.resource()).add("IsPublic", (Object)this.isPublic()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Condition", this.hasCondition() ? this.condition() : null).add("CreatedAt", (Object)this.createdAt()).add("AnalyzedAt", (Object)this.analyzedAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Status", (Object)this.statusAsString()).add("ResourceOwnerAccount", (Object)this.resourceOwnerAccount()).add("Error", (Object)this.error()).add("Sources", this.hasSources() ? this.sources() : null).add("ResourceControlPolicyRestriction", (Object)this.resourceControlPolicyRestrictionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "isPublic": {
                return Optional.ofNullable(clazz.cast(this.isPublic()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "analyzedAt": {
                return Optional.ofNullable(clazz.cast(this.analyzedAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "resourceOwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerAccount()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "resourceControlPolicyRestriction": {
                return Optional.ofNullable(clazz.cast(this.resourceControlPolicyRestrictionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("isPublic", IS_PUBLIC_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("condition", CONDITION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("analyzedAt", ANALYZED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("resourceOwnerAccount", RESOURCE_OWNER_ACCOUNT_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("resourceControlPolicyRestriction", RESOURCE_CONTROL_POLICY_RESTRICTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingSummary, T> g) {
        return obj -> g.apply((FindingSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Map<String, String> principal = DefaultSdkAutoConstructMap.getInstance();
        private List<String> action = DefaultSdkAutoConstructList.getInstance();
        private String resource;
        private Boolean isPublic;
        private String resourceType;
        private Map<String, String> condition = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdAt;
        private Instant analyzedAt;
        private Instant updatedAt;
        private String status;
        private String resourceOwnerAccount;
        private String error;
        private List<FindingSource> sources = DefaultSdkAutoConstructList.getInstance();
        private String resourceControlPolicyRestriction;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingSummary model) {
            this.id(model.id);
            this.principal(model.principal);
            this.action(model.action);
            this.resource(model.resource);
            this.isPublic(model.isPublic);
            this.resourceType(model.resourceType);
            this.condition(model.condition);
            this.createdAt(model.createdAt);
            this.analyzedAt(model.analyzedAt);
            this.updatedAt(model.updatedAt);
            this.status(model.status);
            this.resourceOwnerAccount(model.resourceOwnerAccount);
            this.error(model.error);
            this.sources(model.sources);
            this.resourceControlPolicyRestriction(model.resourceControlPolicyRestriction);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Map<String, String> getPrincipal() {
            if (this.principal instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.principal;
        }

        public final void setPrincipal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
        }

        @Override
        public final Builder principal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
            return this;
        }

        public final Collection<String> getAction() {
            if (this.action instanceof SdkAutoConstructList) {
                return null;
            }
            return this.action;
        }

        public final void setAction(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
        }

        @Override
        public final Builder action(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder action(String ... action) {
            this.action(Arrays.asList(action));
            return this;
        }

        public final String getResource() {
            return this.resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final Boolean getIsPublic() {
            return this.isPublic;
        }

        public final void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        @Override
        public final Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Map<String, String> getCondition() {
            if (this.condition instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.condition;
        }

        public final void setCondition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
        }

        @Override
        public final Builder condition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getAnalyzedAt() {
            return this.analyzedAt;
        }

        public final void setAnalyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
        }

        @Override
        public final Builder analyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FindingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getResourceOwnerAccount() {
            return this.resourceOwnerAccount;
        }

        public final void setResourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
        }

        @Override
        public final Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final List<FindingSource.Builder> getSources() {
            List<FindingSource.Builder> result = FindingSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<FindingSource.BuilderImpl> sources) {
            this.sources = FindingSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<FindingSource> sources) {
            this.sources = FindingSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(FindingSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<FindingSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (FindingSource)((FindingSource.Builder)FindingSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResourceControlPolicyRestriction() {
            return this.resourceControlPolicyRestriction;
        }

        public final void setResourceControlPolicyRestriction(String resourceControlPolicyRestriction) {
            this.resourceControlPolicyRestriction = resourceControlPolicyRestriction;
        }

        @Override
        public final Builder resourceControlPolicyRestriction(String resourceControlPolicyRestriction) {
            this.resourceControlPolicyRestriction = resourceControlPolicyRestriction;
            return this;
        }

        @Override
        public final Builder resourceControlPolicyRestriction(ResourceControlPolicyRestriction resourceControlPolicyRestriction) {
            this.resourceControlPolicyRestriction(resourceControlPolicyRestriction == null ? null : resourceControlPolicyRestriction.toString());
            return this;
        }

        public FindingSummary build() {
            return new FindingSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingSummary> {
        public Builder id(String var1);

        public Builder principal(Map<String, String> var1);

        public Builder action(Collection<String> var1);

        public Builder action(String ... var1);

        public Builder resource(String var1);

        public Builder isPublic(Boolean var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder condition(Map<String, String> var1);

        public Builder createdAt(Instant var1);

        public Builder analyzedAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(FindingStatus var1);

        public Builder resourceOwnerAccount(String var1);

        public Builder error(String var1);

        public Builder sources(Collection<FindingSource> var1);

        public Builder sources(FindingSource ... var1);

        public Builder sources(Consumer<FindingSource.Builder> ... var1);

        public Builder resourceControlPolicyRestriction(String var1);

        public Builder resourceControlPolicyRestriction(ResourceControlPolicyRestriction var1);
    }
}

