/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.Access;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.AccessCheckPolicyType;
import software.amazon.awssdk.services.accessanalyzer.model.CheckAccessNotGrantedRequestAccessListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckAccessNotGrantedRequest
extends AccessAnalyzerRequest
implements ToCopyableBuilder<Builder, CheckAccessNotGrantedRequest> {
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyDocument").getter(CheckAccessNotGrantedRequest.getter(CheckAccessNotGrantedRequest::policyDocument)).setter(CheckAccessNotGrantedRequest.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()}).build();
    private static final SdkField<List<Access>> ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("access").getter(CheckAccessNotGrantedRequest.getter(CheckAccessNotGrantedRequest::access)).setter(CheckAccessNotGrantedRequest.setter(Builder::access)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("access").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Access::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyType").getter(CheckAccessNotGrantedRequest.getter(CheckAccessNotGrantedRequest::policyTypeAsString)).setter(CheckAccessNotGrantedRequest.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_DOCUMENT_FIELD, ACCESS_FIELD, POLICY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CheckAccessNotGrantedRequest.memberNameToFieldInitializer();
    private final String policyDocument;
    private final List<Access> access;
    private final String policyType;

    private CheckAccessNotGrantedRequest(BuilderImpl builder) {
        super(builder);
        this.policyDocument = builder.policyDocument;
        this.access = builder.access;
        this.policyType = builder.policyType;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final boolean hasAccess() {
        return this.access != null && !(this.access instanceof SdkAutoConstructList);
    }

    public final List<Access> access() {
        return this.access;
    }

    public final AccessCheckPolicyType policyType() {
        return AccessCheckPolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccess() ? this.access() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckAccessNotGrantedRequest)) {
            return false;
        }
        CheckAccessNotGrantedRequest other = (CheckAccessNotGrantedRequest)((Object)obj);
        return Objects.equals(this.policyDocument(), other.policyDocument()) && this.hasAccess() == other.hasAccess() && Objects.equals(this.access(), other.access()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CheckAccessNotGrantedRequest").add("PolicyDocument", (Object)(this.policyDocument() == null ? null : "*** Sensitive Data Redacted ***")).add("Access", this.hasAccess() ? this.access() : null).add("PolicyType", (Object)this.policyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "access": {
                return Optional.ofNullable(clazz.cast(this.access()));
            }
            case "policyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        map.put("access", ACCESS_FIELD);
        map.put("policyType", POLICY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckAccessNotGrantedRequest, T> g) {
        return obj -> g.apply((CheckAccessNotGrantedRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerRequest.BuilderImpl
    implements Builder {
        private String policyDocument;
        private List<Access> access = DefaultSdkAutoConstructList.getInstance();
        private String policyType;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckAccessNotGrantedRequest model) {
            super(model);
            this.policyDocument(model.policyDocument);
            this.access(model.access);
            this.policyType(model.policyType);
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final List<Access.Builder> getAccess() {
            List<Access.Builder> result = CheckAccessNotGrantedRequestAccessListCopier.copyToBuilder(this.access);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccess(Collection<Access.BuilderImpl> access) {
            this.access = CheckAccessNotGrantedRequestAccessListCopier.copyFromBuilder(access);
        }

        @Override
        public final Builder access(Collection<Access> access) {
            this.access = CheckAccessNotGrantedRequestAccessListCopier.copy(access);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder access(Access ... access) {
            this.access(Arrays.asList(access));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder access(Consumer<Access.Builder> ... access) {
            this.access(Stream.of(access).map(c -> (Access)((Access.Builder)Access.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(AccessCheckPolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckAccessNotGrantedRequest build() {
            return new CheckAccessNotGrantedRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AccessAnalyzerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CheckAccessNotGrantedRequest> {
        public Builder policyDocument(String var1);

        public Builder access(Collection<Access> var1);

        public Builder access(Access ... var1);

        public Builder access(Consumer<Access.Builder> ... var1);

        public Builder policyType(String var1);

        public Builder policyType(AccessCheckPolicyType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

