/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.CheckAccessNotGrantedResult;
import software.amazon.awssdk.services.accessanalyzer.model.ReasonSummary;
import software.amazon.awssdk.services.accessanalyzer.model.ReasonSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckAccessNotGrantedResponse
extends AccessAnalyzerResponse
implements ToCopyableBuilder<Builder, CheckAccessNotGrantedResponse> {
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("result").getter(CheckAccessNotGrantedResponse.getter(CheckAccessNotGrantedResponse::resultAsString)).setter(CheckAccessNotGrantedResponse.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(CheckAccessNotGrantedResponse.getter(CheckAccessNotGrantedResponse::message)).setter(CheckAccessNotGrantedResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<List<ReasonSummary>> REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reasons").getter(CheckAccessNotGrantedResponse.getter(CheckAccessNotGrantedResponse::reasons)).setter(CheckAccessNotGrantedResponse.setter(Builder::reasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReasonSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FIELD, MESSAGE_FIELD, REASONS_FIELD));
    private final String result;
    private final String message;
    private final List<ReasonSummary> reasons;

    private CheckAccessNotGrantedResponse(BuilderImpl builder) {
        super(builder);
        this.result = builder.result;
        this.message = builder.message;
        this.reasons = builder.reasons;
    }

    public final CheckAccessNotGrantedResult result() {
        return CheckAccessNotGrantedResult.fromValue(this.result);
    }

    public final String resultAsString() {
        return this.result;
    }

    public final String message() {
        return this.message;
    }

    public final boolean hasReasons() {
        return this.reasons != null && !(this.reasons instanceof SdkAutoConstructList);
    }

    public final List<ReasonSummary> reasons() {
        return this.reasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReasons() ? this.reasons() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckAccessNotGrantedResponse)) {
            return false;
        }
        CheckAccessNotGrantedResponse other = (CheckAccessNotGrantedResponse)((Object)obj);
        return Objects.equals(this.resultAsString(), other.resultAsString()) && Objects.equals(this.message(), other.message()) && this.hasReasons() == other.hasReasons() && Objects.equals(this.reasons(), other.reasons());
    }

    public final String toString() {
        return ToString.builder((String)"CheckAccessNotGrantedResponse").add("Result", (Object)this.resultAsString()).add("Message", (Object)this.message()).add("Reasons", this.hasReasons() ? this.reasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "result": {
                return Optional.ofNullable(clazz.cast(this.resultAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "reasons": {
                return Optional.ofNullable(clazz.cast(this.reasons()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckAccessNotGrantedResponse, T> g) {
        return obj -> g.apply((CheckAccessNotGrantedResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerResponse.BuilderImpl
    implements Builder {
        private String result;
        private String message;
        private List<ReasonSummary> reasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CheckAccessNotGrantedResponse model) {
            super(model);
            this.result(model.result);
            this.message(model.message);
            this.reasons(model.reasons);
        }

        public final String getResult() {
            return this.result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(CheckAccessNotGrantedResult result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final List<ReasonSummary.Builder> getReasons() {
            List<ReasonSummary.Builder> result = ReasonSummaryListCopier.copyToBuilder(this.reasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReasons(Collection<ReasonSummary.BuilderImpl> reasons) {
            this.reasons = ReasonSummaryListCopier.copyFromBuilder(reasons);
        }

        @Override
        public final Builder reasons(Collection<ReasonSummary> reasons) {
            this.reasons = ReasonSummaryListCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(ReasonSummary ... reasons) {
            this.reasons(Arrays.asList(reasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(Consumer<ReasonSummary.Builder> ... reasons) {
            this.reasons(Stream.of(reasons).map(c -> (ReasonSummary)((ReasonSummary.Builder)ReasonSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CheckAccessNotGrantedResponse build() {
            return new CheckAccessNotGrantedResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AccessAnalyzerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CheckAccessNotGrantedResponse> {
        public Builder result(String var1);

        public Builder result(CheckAccessNotGrantedResult var1);

        public Builder message(String var1);

        public Builder reasons(Collection<ReasonSummary> var1);

        public Builder reasons(ReasonSummary ... var1);

        public Builder reasons(Consumer<ReasonSummary.Builder> ... var1);
    }
}

