/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerAsyncClient;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerAsyncClientBuilder;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerServiceClientConfiguration;
import software.amazon.awssdk.services.accessanalyzer.DefaultAccessAnalyzerAsyncClient;
import software.amazon.awssdk.services.accessanalyzer.DefaultAccessAnalyzerBaseClientBuilder;
import software.amazon.awssdk.services.accessanalyzer.endpoints.AccessAnalyzerEndpointProvider;

@SdkInternalApi
final class DefaultAccessAnalyzerAsyncClientBuilder
extends DefaultAccessAnalyzerBaseClientBuilder<AccessAnalyzerAsyncClientBuilder, AccessAnalyzerAsyncClient>
implements AccessAnalyzerAsyncClientBuilder {
    DefaultAccessAnalyzerAsyncClientBuilder() {
    }

    @Override
    public DefaultAccessAnalyzerAsyncClientBuilder endpointProvider(AccessAnalyzerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AccessAnalyzerAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAccessAnalyzerAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        AccessAnalyzerServiceClientConfiguration serviceClientConfiguration = AccessAnalyzerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultAccessAnalyzerAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

