/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerAsyncClient;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerServiceClientConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerException;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.AccessDeniedException;
import software.amazon.awssdk.services.accessanalyzer.model.ApplyArchiveRuleRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ApplyArchiveRuleResponse;
import software.amazon.awssdk.services.accessanalyzer.model.CancelPolicyGenerationRequest;
import software.amazon.awssdk.services.accessanalyzer.model.CancelPolicyGenerationResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ConflictException;
import software.amazon.awssdk.services.accessanalyzer.model.CreateAccessPreviewRequest;
import software.amazon.awssdk.services.accessanalyzer.model.CreateAccessPreviewResponse;
import software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleRequest;
import software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleResponse;
import software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleRequest;
import software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleResponse;
import software.amazon.awssdk.services.accessanalyzer.model.GetAccessPreviewRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetAccessPreviewResponse;
import software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceResponse;
import software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleResponse;
import software.amazon.awssdk.services.accessanalyzer.model.GetFindingRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetFindingResponse;
import software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyResponse;
import software.amazon.awssdk.services.accessanalyzer.model.InternalServerException;
import software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListFindingsResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceNotFoundException;
import software.amazon.awssdk.services.accessanalyzer.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.accessanalyzer.model.StartPolicyGenerationRequest;
import software.amazon.awssdk.services.accessanalyzer.model.StartPolicyGenerationResponse;
import software.amazon.awssdk.services.accessanalyzer.model.StartResourceScanRequest;
import software.amazon.awssdk.services.accessanalyzer.model.StartResourceScanResponse;
import software.amazon.awssdk.services.accessanalyzer.model.TagResourceRequest;
import software.amazon.awssdk.services.accessanalyzer.model.TagResourceResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ThrottlingException;
import software.amazon.awssdk.services.accessanalyzer.model.UntagResourceRequest;
import software.amazon.awssdk.services.accessanalyzer.model.UntagResourceResponse;
import software.amazon.awssdk.services.accessanalyzer.model.UpdateArchiveRuleRequest;
import software.amazon.awssdk.services.accessanalyzer.model.UpdateArchiveRuleResponse;
import software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ValidationException;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListAccessPreviewFindingsPublisher;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListAccessPreviewsPublisher;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListAnalyzedResourcesPublisher;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListAnalyzersPublisher;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListArchiveRulesPublisher;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListFindingsPublisher;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListPolicyGenerationsPublisher;
import software.amazon.awssdk.services.accessanalyzer.paginators.ValidatePolicyPublisher;
import software.amazon.awssdk.services.accessanalyzer.transform.ApplyArchiveRuleRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.CancelPolicyGenerationRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.CreateAccessPreviewRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.CreateAnalyzerRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.CreateArchiveRuleRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.DeleteAnalyzerRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.DeleteArchiveRuleRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.GetAccessPreviewRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.GetAnalyzedResourceRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.GetAnalyzerRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.GetArchiveRuleRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.GetFindingRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.GetGeneratedPolicyRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.ListAccessPreviewFindingsRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.ListAccessPreviewsRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.ListAnalyzedResourcesRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.ListAnalyzersRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.ListArchiveRulesRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.ListFindingsRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.ListPolicyGenerationsRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.StartPolicyGenerationRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.StartResourceScanRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.UpdateArchiveRuleRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.UpdateFindingsRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.ValidatePolicyRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultAccessAnalyzerAsyncClient
implements AccessAnalyzerAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultAccessAnalyzerAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final AccessAnalyzerServiceClientConfiguration serviceClientConfiguration;

    protected DefaultAccessAnalyzerAsyncClient(AccessAnalyzerServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<ApplyArchiveRuleResponse> applyArchiveRule(ApplyArchiveRuleRequest applyArchiveRuleRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, applyArchiveRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ApplyArchiveRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ApplyArchiveRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplyArchiveRule").withMarshaller((Marshaller)new ApplyArchiveRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)applyArchiveRuleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$applyArchiveRule$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$applyArchiveRule$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelPolicyGenerationResponse> cancelPolicyGeneration(CancelPolicyGenerationRequest cancelPolicyGenerationRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, cancelPolicyGenerationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelPolicyGeneration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelPolicyGenerationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelPolicyGeneration").withMarshaller((Marshaller)new CancelPolicyGenerationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelPolicyGenerationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$cancelPolicyGeneration$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$cancelPolicyGeneration$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAccessPreviewResponse> createAccessPreview(CreateAccessPreviewRequest createAccessPreviewRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, createAccessPreviewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccessPreview");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAccessPreviewResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccessPreview").withMarshaller((Marshaller)new CreateAccessPreviewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAccessPreviewRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$createAccessPreview$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$createAccessPreview$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAnalyzerResponse> createAnalyzer(CreateAnalyzerRequest createAnalyzerRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, createAnalyzerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAnalyzer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAnalyzerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAnalyzer").withMarshaller((Marshaller)new CreateAnalyzerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAnalyzerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$createAnalyzer$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$createAnalyzer$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateArchiveRuleResponse> createArchiveRule(CreateArchiveRuleRequest createArchiveRuleRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, createArchiveRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateArchiveRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateArchiveRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateArchiveRule").withMarshaller((Marshaller)new CreateArchiveRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createArchiveRuleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$createArchiveRule$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$createArchiveRule$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAnalyzerResponse> deleteAnalyzer(DeleteAnalyzerRequest deleteAnalyzerRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteAnalyzerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAnalyzer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAnalyzerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAnalyzer").withMarshaller((Marshaller)new DeleteAnalyzerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAnalyzerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$deleteAnalyzer$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$deleteAnalyzer$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteArchiveRuleResponse> deleteArchiveRule(DeleteArchiveRuleRequest deleteArchiveRuleRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteArchiveRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteArchiveRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteArchiveRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteArchiveRule").withMarshaller((Marshaller)new DeleteArchiveRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteArchiveRuleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$deleteArchiveRule$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$deleteArchiveRule$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAccessPreviewResponse> getAccessPreview(GetAccessPreviewRequest getAccessPreviewRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAccessPreviewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPreview");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccessPreviewResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPreview").withMarshaller((Marshaller)new GetAccessPreviewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAccessPreviewRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$getAccessPreview$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$getAccessPreview$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAnalyzedResourceResponse> getAnalyzedResource(GetAnalyzedResourceRequest getAnalyzedResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAnalyzedResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnalyzedResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnalyzedResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnalyzedResource").withMarshaller((Marshaller)new GetAnalyzedResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAnalyzedResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$getAnalyzedResource$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$getAnalyzedResource$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAnalyzerResponse> getAnalyzer(GetAnalyzerRequest getAnalyzerRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAnalyzerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnalyzer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnalyzerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnalyzer").withMarshaller((Marshaller)new GetAnalyzerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAnalyzerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$getAnalyzer$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$getAnalyzer$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetArchiveRuleResponse> getArchiveRule(GetArchiveRuleRequest getArchiveRuleRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, getArchiveRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetArchiveRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetArchiveRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetArchiveRule").withMarshaller((Marshaller)new GetArchiveRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getArchiveRuleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$getArchiveRule$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$getArchiveRule$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFindingResponse> getFinding(GetFindingRequest getFindingRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, getFindingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFinding");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFindingResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFinding").withMarshaller((Marshaller)new GetFindingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFindingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$getFinding$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$getFinding$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetGeneratedPolicyResponse> getGeneratedPolicy(GetGeneratedPolicyRequest getGeneratedPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, getGeneratedPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGeneratedPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGeneratedPolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGeneratedPolicy").withMarshaller((Marshaller)new GetGeneratedPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getGeneratedPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$getGeneratedPolicy$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$getGeneratedPolicy$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAccessPreviewFindingsResponse> listAccessPreviewFindings(ListAccessPreviewFindingsRequest listAccessPreviewFindingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, listAccessPreviewFindingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccessPreviewFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccessPreviewFindingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccessPreviewFindings").withMarshaller((Marshaller)new ListAccessPreviewFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAccessPreviewFindingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$listAccessPreviewFindings$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$listAccessPreviewFindings$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListAccessPreviewFindingsPublisher listAccessPreviewFindingsPaginator(ListAccessPreviewFindingsRequest listAccessPreviewFindingsRequest) {
        return new ListAccessPreviewFindingsPublisher(this, this.applyPaginatorUserAgent(listAccessPreviewFindingsRequest));
    }

    @Override
    public CompletableFuture<ListAccessPreviewsResponse> listAccessPreviews(ListAccessPreviewsRequest listAccessPreviewsRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, listAccessPreviewsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccessPreviews");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccessPreviewsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccessPreviews").withMarshaller((Marshaller)new ListAccessPreviewsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAccessPreviewsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$listAccessPreviews$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$listAccessPreviews$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListAccessPreviewsPublisher listAccessPreviewsPaginator(ListAccessPreviewsRequest listAccessPreviewsRequest) {
        return new ListAccessPreviewsPublisher(this, this.applyPaginatorUserAgent(listAccessPreviewsRequest));
    }

    @Override
    public CompletableFuture<ListAnalyzedResourcesResponse> listAnalyzedResources(ListAnalyzedResourcesRequest listAnalyzedResourcesRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, listAnalyzedResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAnalyzedResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAnalyzedResourcesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAnalyzedResources").withMarshaller((Marshaller)new ListAnalyzedResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAnalyzedResourcesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$listAnalyzedResources$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$listAnalyzedResources$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListAnalyzedResourcesPublisher listAnalyzedResourcesPaginator(ListAnalyzedResourcesRequest listAnalyzedResourcesRequest) {
        return new ListAnalyzedResourcesPublisher(this, this.applyPaginatorUserAgent(listAnalyzedResourcesRequest));
    }

    @Override
    public CompletableFuture<ListAnalyzersResponse> listAnalyzers(ListAnalyzersRequest listAnalyzersRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, listAnalyzersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAnalyzers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAnalyzersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAnalyzers").withMarshaller((Marshaller)new ListAnalyzersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAnalyzersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$listAnalyzers$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$listAnalyzers$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListAnalyzersPublisher listAnalyzersPaginator(ListAnalyzersRequest listAnalyzersRequest) {
        return new ListAnalyzersPublisher(this, this.applyPaginatorUserAgent(listAnalyzersRequest));
    }

    @Override
    public CompletableFuture<ListArchiveRulesResponse> listArchiveRules(ListArchiveRulesRequest listArchiveRulesRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, listArchiveRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListArchiveRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListArchiveRulesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListArchiveRules").withMarshaller((Marshaller)new ListArchiveRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listArchiveRulesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$listArchiveRules$52(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$listArchiveRules$53((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListArchiveRulesPublisher listArchiveRulesPaginator(ListArchiveRulesRequest listArchiveRulesRequest) {
        return new ListArchiveRulesPublisher(this, this.applyPaginatorUserAgent(listArchiveRulesRequest));
    }

    @Override
    public CompletableFuture<ListFindingsResponse> listFindings(ListFindingsRequest listFindingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, listFindingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFindingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFindings").withMarshaller((Marshaller)new ListFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFindingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$listFindings$55(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$listFindings$56((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListFindingsPublisher listFindingsPaginator(ListFindingsRequest listFindingsRequest) {
        return new ListFindingsPublisher(this, this.applyPaginatorUserAgent(listFindingsRequest));
    }

    @Override
    public CompletableFuture<ListPolicyGenerationsResponse> listPolicyGenerations(ListPolicyGenerationsRequest listPolicyGenerationsRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, listPolicyGenerationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPolicyGenerations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPolicyGenerationsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPolicyGenerations").withMarshaller((Marshaller)new ListPolicyGenerationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPolicyGenerationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$listPolicyGenerations$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$listPolicyGenerations$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListPolicyGenerationsPublisher listPolicyGenerationsPaginator(ListPolicyGenerationsRequest listPolicyGenerationsRequest) {
        return new ListPolicyGenerationsPublisher(this, this.applyPaginatorUserAgent(listPolicyGenerationsRequest));
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$listTagsForResource$61(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$listTagsForResource$62((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartPolicyGenerationResponse> startPolicyGeneration(StartPolicyGenerationRequest startPolicyGenerationRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, startPolicyGenerationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartPolicyGeneration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartPolicyGenerationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartPolicyGeneration").withMarshaller((Marshaller)new StartPolicyGenerationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startPolicyGenerationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$startPolicyGeneration$64(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$startPolicyGeneration$65((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartResourceScanResponse> startResourceScan(StartResourceScanRequest startResourceScanRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, startResourceScanRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartResourceScan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartResourceScanResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartResourceScan").withMarshaller((Marshaller)new StartResourceScanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startResourceScanRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$startResourceScan$67(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$startResourceScan$68((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$tagResource$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$tagResource$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$untagResource$73(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$untagResource$74((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateArchiveRuleResponse> updateArchiveRule(UpdateArchiveRuleRequest updateArchiveRuleRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateArchiveRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateArchiveRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateArchiveRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateArchiveRule").withMarshaller((Marshaller)new UpdateArchiveRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateArchiveRuleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$updateArchiveRule$76(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$updateArchiveRule$77((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFindingsResponse> updateFindings(UpdateFindingsRequest updateFindingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateFindingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFindingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFindings").withMarshaller((Marshaller)new UpdateFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFindingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$updateFindings$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$updateFindings$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ValidatePolicyResponse> validatePolicy(ValidatePolicyRequest validatePolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerAsyncClient.resolveMetricPublishers(this.clientConfiguration, validatePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ValidatePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ValidatePolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ValidatePolicy").withMarshaller((Marshaller)new ValidatePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)validatePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAccessAnalyzerAsyncClient.lambda$validatePolicy$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAccessAnalyzerAsyncClient.lambda$validatePolicy$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ValidatePolicyPublisher validatePolicyPaginator(ValidatePolicyRequest validatePolicyRequest) {
        return new ValidatePolicyPublisher(this, this.applyPaginatorUserAgent(validatePolicyRequest));
    }

    @Override
    public final AccessAnalyzerServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public final String serviceName() {
        return "access-analyzer";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AccessAnalyzerException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends AccessAnalyzerRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.75").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AccessAnalyzerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$validatePolicy$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$validatePolicy$82(List metricPublishers, MetricCollector apiCallMetricCollector, ValidatePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFindings$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFindings$79(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFindingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateArchiveRule$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateArchiveRule$76(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateArchiveRuleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$73(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$70(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startResourceScan$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startResourceScan$67(List metricPublishers, MetricCollector apiCallMetricCollector, StartResourceScanResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startPolicyGeneration$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startPolicyGeneration$64(List metricPublishers, MetricCollector apiCallMetricCollector, StartPolicyGenerationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$61(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPolicyGenerations$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPolicyGenerations$58(List metricPublishers, MetricCollector apiCallMetricCollector, ListPolicyGenerationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFindings$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFindings$55(List metricPublishers, MetricCollector apiCallMetricCollector, ListFindingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listArchiveRules$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listArchiveRules$52(List metricPublishers, MetricCollector apiCallMetricCollector, ListArchiveRulesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAnalyzers$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAnalyzers$49(List metricPublishers, MetricCollector apiCallMetricCollector, ListAnalyzersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAnalyzedResources$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAnalyzedResources$46(List metricPublishers, MetricCollector apiCallMetricCollector, ListAnalyzedResourcesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAccessPreviews$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccessPreviews$43(List metricPublishers, MetricCollector apiCallMetricCollector, ListAccessPreviewsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAccessPreviewFindings$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccessPreviewFindings$40(List metricPublishers, MetricCollector apiCallMetricCollector, ListAccessPreviewFindingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getGeneratedPolicy$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGeneratedPolicy$37(List metricPublishers, MetricCollector apiCallMetricCollector, GetGeneratedPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getFinding$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFinding$34(List metricPublishers, MetricCollector apiCallMetricCollector, GetFindingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getArchiveRule$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getArchiveRule$31(List metricPublishers, MetricCollector apiCallMetricCollector, GetArchiveRuleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAnalyzer$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAnalyzer$28(List metricPublishers, MetricCollector apiCallMetricCollector, GetAnalyzerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAnalyzedResource$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAnalyzedResource$25(List metricPublishers, MetricCollector apiCallMetricCollector, GetAnalyzedResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAccessPreview$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPreview$22(List metricPublishers, MetricCollector apiCallMetricCollector, GetAccessPreviewResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteArchiveRule$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteArchiveRule$19(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteArchiveRuleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAnalyzer$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAnalyzer$16(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAnalyzerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createArchiveRule$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createArchiveRule$13(List metricPublishers, MetricCollector apiCallMetricCollector, CreateArchiveRuleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAnalyzer$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAnalyzer$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAnalyzerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAccessPreview$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccessPreview$7(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAccessPreviewResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$cancelPolicyGeneration$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelPolicyGeneration$4(List metricPublishers, MetricCollector apiCallMetricCollector, CancelPolicyGenerationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$applyArchiveRule$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$applyArchiveRule$1(List metricPublishers, MetricCollector apiCallMetricCollector, ApplyArchiveRuleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

