/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.AclGrantee;
import software.amazon.awssdk.services.accessanalyzer.model.AclPermission;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3BucketAclGrantConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3BucketAclGrantConfiguration> {
    private static final SdkField<AclGrantee> GRANTEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("grantee").getter(S3BucketAclGrantConfiguration.getter(S3BucketAclGrantConfiguration::grantee)).setter(S3BucketAclGrantConfiguration.setter(Builder::grantee)).constructor(AclGrantee::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantee").build()}).build();
    private static final SdkField<String> PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permission").getter(S3BucketAclGrantConfiguration.getter(S3BucketAclGrantConfiguration::permissionAsString)).setter(S3BucketAclGrantConfiguration.setter(Builder::permission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permission").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANTEE_FIELD, PERMISSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final AclGrantee grantee;
    private final String permission;

    private S3BucketAclGrantConfiguration(BuilderImpl builder) {
        this.grantee = builder.grantee;
        this.permission = builder.permission;
    }

    public final AclGrantee grantee() {
        return this.grantee;
    }

    public final AclPermission permission() {
        return AclPermission.fromValue(this.permission);
    }

    public final String permissionAsString() {
        return this.permission;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.grantee());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketAclGrantConfiguration)) {
            return false;
        }
        S3BucketAclGrantConfiguration other = (S3BucketAclGrantConfiguration)obj;
        return Objects.equals(this.grantee(), other.grantee()) && Objects.equals(this.permissionAsString(), other.permissionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"S3BucketAclGrantConfiguration").add("Grantee", (Object)this.grantee()).add("Permission", (Object)this.permissionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "grantee": {
                return Optional.ofNullable(clazz.cast(this.grantee()));
            }
            case "permission": {
                return Optional.ofNullable(clazz.cast(this.permissionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3BucketAclGrantConfiguration, T> g) {
        return obj -> g.apply((S3BucketAclGrantConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AclGrantee grantee;
        private String permission;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketAclGrantConfiguration model) {
            this.grantee(model.grantee);
            this.permission(model.permission);
        }

        public final AclGrantee.Builder getGrantee() {
            return this.grantee != null ? this.grantee.toBuilder() : null;
        }

        public final void setGrantee(AclGrantee.BuilderImpl grantee) {
            this.grantee = grantee != null ? grantee.build() : null;
        }

        @Override
        @Transient
        public final Builder grantee(AclGrantee grantee) {
            this.grantee = grantee;
            return this;
        }

        public final String getPermission() {
            return this.permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        @Transient
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        @Transient
        public final Builder permission(AclPermission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public S3BucketAclGrantConfiguration build() {
            return new S3BucketAclGrantConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3BucketAclGrantConfiguration> {
        public Builder grantee(AclGrantee var1);

        default public Builder grantee(Consumer<AclGrantee.Builder> grantee) {
            return this.grantee((AclGrantee)((AclGrantee.Builder)AclGrantee.builder().applyMutation(grantee)).build());
        }

        public Builder permission(String var1);

        public Builder permission(AclPermission var1);
    }
}

