/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.InternetConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.VpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkOriginConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkOriginConfiguration> {
    private static final SdkField<InternetConfiguration> INTERNET_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("internetConfiguration").getter(NetworkOriginConfiguration.getter(NetworkOriginConfiguration::internetConfiguration)).setter(NetworkOriginConfiguration.setter(Builder::internetConfiguration)).constructor(InternetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("internetConfiguration").build()}).build();
    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfiguration").getter(NetworkOriginConfiguration.getter(NetworkOriginConfiguration::vpcConfiguration)).setter(NetworkOriginConfiguration.setter(Builder::vpcConfiguration)).constructor(VpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERNET_CONFIGURATION_FIELD, VPC_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final InternetConfiguration internetConfiguration;
    private final VpcConfiguration vpcConfiguration;
    private final Type type;

    private NetworkOriginConfiguration(BuilderImpl builder) {
        this.internetConfiguration = builder.internetConfiguration;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.type = builder.type;
    }

    public final InternetConfiguration internetConfiguration() {
        return this.internetConfiguration;
    }

    public final VpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.internetConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkOriginConfiguration)) {
            return false;
        }
        NetworkOriginConfiguration other = (NetworkOriginConfiguration)obj;
        return Objects.equals(this.internetConfiguration(), other.internetConfiguration()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkOriginConfiguration").add("InternetConfiguration", (Object)this.internetConfiguration()).add("VpcConfiguration", (Object)this.vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "internetConfiguration": {
                return Optional.ofNullable(clazz.cast(this.internetConfiguration()));
            }
            case "vpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static NetworkOriginConfiguration fromInternetConfiguration(InternetConfiguration internetConfiguration) {
        return (NetworkOriginConfiguration)NetworkOriginConfiguration.builder().internetConfiguration(internetConfiguration).build();
    }

    public static NetworkOriginConfiguration fromInternetConfiguration(Consumer<InternetConfiguration.Builder> internetConfiguration) {
        InternetConfiguration.Builder builder = InternetConfiguration.builder();
        internetConfiguration.accept(builder);
        return NetworkOriginConfiguration.fromInternetConfiguration((InternetConfiguration)builder.build());
    }

    public static NetworkOriginConfiguration fromVpcConfiguration(VpcConfiguration vpcConfiguration) {
        return (NetworkOriginConfiguration)NetworkOriginConfiguration.builder().vpcConfiguration(vpcConfiguration).build();
    }

    public static NetworkOriginConfiguration fromVpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
        VpcConfiguration.Builder builder = VpcConfiguration.builder();
        vpcConfiguration.accept(builder);
        return NetworkOriginConfiguration.fromVpcConfiguration((VpcConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkOriginConfiguration, T> g) {
        return obj -> g.apply((NetworkOriginConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INTERNET_CONFIGURATION,
        VPC_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private InternetConfiguration internetConfiguration;
        private VpcConfiguration vpcConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkOriginConfiguration model) {
            this.internetConfiguration(model.internetConfiguration);
            this.vpcConfiguration(model.vpcConfiguration);
        }

        public final InternetConfiguration.Builder getInternetConfiguration() {
            return this.internetConfiguration != null ? this.internetConfiguration.toBuilder() : null;
        }

        public final void setInternetConfiguration(InternetConfiguration.BuilderImpl internetConfiguration) {
            InternetConfiguration oldValue = this.internetConfiguration;
            this.internetConfiguration = internetConfiguration != null ? internetConfiguration.build() : null;
            this.handleUnionValueChange(Type.INTERNET_CONFIGURATION, oldValue, this.internetConfiguration);
        }

        @Override
        public final Builder internetConfiguration(InternetConfiguration internetConfiguration) {
            InternetConfiguration oldValue = this.internetConfiguration;
            this.internetConfiguration = internetConfiguration;
            this.handleUnionValueChange(Type.INTERNET_CONFIGURATION, oldValue, this.internetConfiguration);
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            VpcConfiguration oldValue = this.vpcConfiguration;
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
            this.handleUnionValueChange(Type.VPC_CONFIGURATION, oldValue, this.vpcConfiguration);
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            VpcConfiguration oldValue = this.vpcConfiguration;
            this.vpcConfiguration = vpcConfiguration;
            this.handleUnionValueChange(Type.VPC_CONFIGURATION, oldValue, this.vpcConfiguration);
            return this;
        }

        public NetworkOriginConfiguration build() {
            return new NetworkOriginConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkOriginConfiguration> {
        public Builder internetConfiguration(InternetConfiguration var1);

        default public Builder internetConfiguration(Consumer<InternetConfiguration.Builder> internetConfiguration) {
            return this.internetConfiguration((InternetConfiguration)((InternetConfiguration.Builder)InternetConfiguration.builder().applyMutation(internetConfiguration)).build());
        }

        public Builder vpcConfiguration(VpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((VpcConfiguration)((VpcConfiguration.Builder)VpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }
    }
}

