/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResourceSummary;
import software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResourcesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnalyzedResourcesResponse
extends AccessAnalyzerResponse
implements ToCopyableBuilder<Builder, ListAnalyzedResourcesResponse> {
    private static final SdkField<List<AnalyzedResourceSummary>> ANALYZED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("analyzedResources").getter(ListAnalyzedResourcesResponse.getter(ListAnalyzedResourcesResponse::analyzedResources)).setter(ListAnalyzedResourcesResponse.setter(Builder::analyzedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyzedResourceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAnalyzedResourcesResponse.getter(ListAnalyzedResourcesResponse::nextToken)).setter(ListAnalyzedResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZED_RESOURCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AnalyzedResourceSummary> analyzedResources;
    private final String nextToken;

    private ListAnalyzedResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.analyzedResources = builder.analyzedResources;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAnalyzedResources() {
        return this.analyzedResources != null && !(this.analyzedResources instanceof SdkAutoConstructList);
    }

    public final List<AnalyzedResourceSummary> analyzedResources() {
        return this.analyzedResources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalyzedResources() ? this.analyzedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnalyzedResourcesResponse)) {
            return false;
        }
        ListAnalyzedResourcesResponse other = (ListAnalyzedResourcesResponse)((Object)obj);
        return this.hasAnalyzedResources() == other.hasAnalyzedResources() && Objects.equals(this.analyzedResources(), other.analyzedResources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAnalyzedResourcesResponse").add("AnalyzedResources", this.hasAnalyzedResources() ? this.analyzedResources() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analyzedResources": {
                return Optional.ofNullable(clazz.cast(this.analyzedResources()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnalyzedResourcesResponse, T> g) {
        return obj -> g.apply((ListAnalyzedResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerResponse.BuilderImpl
    implements Builder {
        private List<AnalyzedResourceSummary> analyzedResources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnalyzedResourcesResponse model) {
            super(model);
            this.analyzedResources(model.analyzedResources);
            this.nextToken(model.nextToken);
        }

        public final List<AnalyzedResourceSummary.Builder> getAnalyzedResources() {
            List<AnalyzedResourceSummary.Builder> result = AnalyzedResourcesListCopier.copyToBuilder(this.analyzedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalyzedResources(Collection<AnalyzedResourceSummary.BuilderImpl> analyzedResources) {
            this.analyzedResources = AnalyzedResourcesListCopier.copyFromBuilder(analyzedResources);
        }

        @Override
        @Transient
        public final Builder analyzedResources(Collection<AnalyzedResourceSummary> analyzedResources) {
            this.analyzedResources = AnalyzedResourcesListCopier.copy(analyzedResources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder analyzedResources(AnalyzedResourceSummary ... analyzedResources) {
            this.analyzedResources(Arrays.asList(analyzedResources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder analyzedResources(Consumer<AnalyzedResourceSummary.Builder> ... analyzedResources) {
            this.analyzedResources(Stream.of(analyzedResources).map(c -> (AnalyzedResourceSummary)((AnalyzedResourceSummary.Builder)AnalyzedResourceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnalyzedResourcesResponse build() {
            return new ListAnalyzedResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AccessAnalyzerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnalyzedResourcesResponse> {
        public Builder analyzedResources(Collection<AnalyzedResourceSummary> var1);

        public Builder analyzedResources(AnalyzedResourceSummary ... var1);

        public Builder analyzedResources(Consumer<AnalyzedResourceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

