/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConfigurationsListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.KmsKeyPoliciesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KmsKeyConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KmsKeyConfiguration> {
    private static final SdkField<List<KmsGrantConfiguration>> GRANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("grants").getter(KmsKeyConfiguration.getter(KmsKeyConfiguration::grants)).setter(KmsKeyConfiguration.setter(Builder::grants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KmsGrantConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> KEY_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("keyPolicies").getter(KmsKeyConfiguration.getter(KmsKeyConfiguration::keyPolicies)).setter(KmsKeyConfiguration.setter(Builder::keyPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPolicies").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANTS_FIELD, KEY_POLICIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<KmsGrantConfiguration> grants;
    private final Map<String, String> keyPolicies;

    private KmsKeyConfiguration(BuilderImpl builder) {
        this.grants = builder.grants;
        this.keyPolicies = builder.keyPolicies;
    }

    public final boolean hasGrants() {
        return this.grants != null && !(this.grants instanceof SdkAutoConstructList);
    }

    public final List<KmsGrantConfiguration> grants() {
        return this.grants;
    }

    public final boolean hasKeyPolicies() {
        return this.keyPolicies != null && !(this.keyPolicies instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> keyPolicies() {
        return this.keyPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrants() ? this.grants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyPolicies() ? this.keyPolicies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KmsKeyConfiguration)) {
            return false;
        }
        KmsKeyConfiguration other = (KmsKeyConfiguration)obj;
        return this.hasGrants() == other.hasGrants() && Objects.equals(this.grants(), other.grants()) && this.hasKeyPolicies() == other.hasKeyPolicies() && Objects.equals(this.keyPolicies(), other.keyPolicies());
    }

    public final String toString() {
        return ToString.builder((String)"KmsKeyConfiguration").add("Grants", this.hasGrants() ? this.grants() : null).add("KeyPolicies", this.hasKeyPolicies() ? this.keyPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "grants": {
                return Optional.ofNullable(clazz.cast(this.grants()));
            }
            case "keyPolicies": {
                return Optional.ofNullable(clazz.cast(this.keyPolicies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KmsKeyConfiguration, T> g) {
        return obj -> g.apply((KmsKeyConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<KmsGrantConfiguration> grants = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> keyPolicies = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KmsKeyConfiguration model) {
            this.grants(model.grants);
            this.keyPolicies(model.keyPolicies);
        }

        public final Collection<KmsGrantConfiguration.Builder> getGrants() {
            if (this.grants instanceof SdkAutoConstructList) {
                return null;
            }
            return this.grants != null ? (Collection)this.grants.stream().map(KmsGrantConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder grants(Collection<KmsGrantConfiguration> grants) {
            this.grants = KmsGrantConfigurationsListCopier.copy(grants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(KmsGrantConfiguration ... grants) {
            this.grants(Arrays.asList(grants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(Consumer<KmsGrantConfiguration.Builder> ... grants) {
            this.grants(Stream.of(grants).map(c -> (KmsGrantConfiguration)((KmsGrantConfiguration.Builder)KmsGrantConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGrants(Collection<KmsGrantConfiguration.BuilderImpl> grants) {
            this.grants = KmsGrantConfigurationsListCopier.copyFromBuilder(grants);
        }

        public final Map<String, String> getKeyPolicies() {
            if (this.keyPolicies instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.keyPolicies;
        }

        @Override
        public final Builder keyPolicies(Map<String, String> keyPolicies) {
            this.keyPolicies = KmsKeyPoliciesMapCopier.copy(keyPolicies);
            return this;
        }

        public final void setKeyPolicies(Map<String, String> keyPolicies) {
            this.keyPolicies = KmsKeyPoliciesMapCopier.copy(keyPolicies);
        }

        public KmsKeyConfiguration build() {
            return new KmsKeyConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KmsKeyConfiguration> {
        public Builder grants(Collection<KmsGrantConfiguration> var1);

        public Builder grants(KmsGrantConfiguration ... var1);

        public Builder grants(Consumer<KmsGrantConfiguration.Builder> ... var1);

        public Builder keyPolicies(Map<String, String> var1);
    }
}

