/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awsconstructs.services.core;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.cloudfront.CfnOriginAccessControl;
import software.amazon.awscdk.services.cloudfront.IOrigin;
import software.amazon.awscdk.services.cloudfront.OriginBindConfig;
import software.amazon.awscdk.services.cloudfront.OriginBindOptions;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awsconstructs.services.core.;
import software.amazon.awsconstructs.services.core.S3OacOriginProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-solutions-constructs/core.S3OacOrigin")
public class S3OacOrigin
extends JsiiObject
implements IOrigin {
    protected S3OacOrigin(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3OacOrigin(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public S3OacOrigin(@NotNull IBucket bucket, @NotNull S3OacOriginProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(bucket, "bucket is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public OriginBindConfig bind(@NotNull Construct scope, @NotNull OriginBindOptions options) {
        return (OriginBindConfig)Kernel.call((Object)((Object)this), (String)"bind", (NativeType)NativeType.forClass(OriginBindConfig.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(options, "options is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<S3OacOrigin> {
        private final IBucket bucket;
        private final S3OacOriginProps.Builder props;

        public static Builder create(IBucket bucket) {
            return new Builder(bucket);
        }

        private Builder(IBucket bucket) {
            this.bucket = bucket;
            this.props = new S3OacOriginProps.Builder();
        }

        public Builder connectionAttempts(Number connectionAttempts) {
            this.props.connectionAttempts(connectionAttempts);
            return this;
        }

        public Builder connectionTimeout(Duration connectionTimeout) {
            this.props.connectionTimeout(connectionTimeout);
            return this;
        }

        public Builder customHeaders(Map<String, String> customHeaders) {
            this.props.customHeaders(customHeaders);
            return this;
        }

        public Builder originId(String originId) {
            this.props.originId(originId);
            return this;
        }

        public Builder originShieldEnabled(Boolean originShieldEnabled) {
            this.props.originShieldEnabled(originShieldEnabled);
            return this;
        }

        public Builder originShieldRegion(String originShieldRegion) {
            this.props.originShieldRegion(originShieldRegion);
            return this;
        }

        public Builder originPath(String originPath) {
            this.props.originPath(originPath);
            return this;
        }

        public Builder originAccessControl(CfnOriginAccessControl originAccessControl) {
            this.props.originAccessControl(originAccessControl);
            return this;
        }

        public S3OacOrigin build() {
            return new S3OacOrigin(this.bucket, this.props.build());
        }
    }
}

