/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions;

import java.util.List;
import java.util.Map;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig;
import software.amazon.jsii.JsiiSerializable;

public interface StepFunctionsTaskConfig
extends JsiiSerializable {
    public String getResourceArn();

    public Duration getHeartbeat();

    public Map<String, Object> getMetricDimensions();

    public String getMetricPrefixPlural();

    public String getMetricPrefixSingular();

    public Map<String, Object> getParameters();

    public List<PolicyStatement> getPolicyStatements();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String resourceArn;
        private Duration heartbeat;
        private Map<String, Object> metricDimensions;
        private String metricPrefixPlural;
        private String metricPrefixSingular;
        private Map<String, Object> parameters;
        private List<PolicyStatement> policyStatements;

        public Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public Builder heartbeat(Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        public Builder metricDimensions(Map<String, Object> metricDimensions) {
            this.metricDimensions = metricDimensions;
            return this;
        }

        public Builder metricPrefixPlural(String metricPrefixPlural) {
            this.metricPrefixPlural = metricPrefixPlural;
            return this;
        }

        public Builder metricPrefixSingular(String metricPrefixSingular) {
            this.metricPrefixSingular = metricPrefixSingular;
            return this;
        }

        public Builder parameters(Map<String, Object> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder policyStatements(List<PolicyStatement> policyStatements) {
            this.policyStatements = policyStatements;
            return this;
        }

        public StepFunctionsTaskConfig build() {
            return new Jsii.Proxy(this.resourceArn, this.heartbeat, this.metricDimensions, this.metricPrefixPlural, this.metricPrefixSingular, this.parameters, this.policyStatements, null);
        }
    }
}

