/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.stepfunctions.IStepFunctionsTaskResource;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface TaskProps
extends JsiiSerializable {
    public IStepFunctionsTaskResource getResource();

    public String getComment();

    public Number getHeartbeatSeconds();

    public String getInputPath();

    public String getOutputPath();

    public Map<String, Object> getParameters();

    public String getResultPath();

    public Number getTimeoutSeconds();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IStepFunctionsTaskResource _resource;
        @Nullable
        private String _comment;
        @Nullable
        private Number _heartbeatSeconds;
        @Nullable
        private String _inputPath;
        @Nullable
        private String _outputPath;
        @Nullable
        private Map<String, Object> _parameters;
        @Nullable
        private String _resultPath;
        @Nullable
        private Number _timeoutSeconds;

        public Builder withResource(IStepFunctionsTaskResource value) {
            this._resource = Objects.requireNonNull(value, "resource is required");
            return this;
        }

        public Builder withComment(@Nullable String value) {
            this._comment = value;
            return this;
        }

        public Builder withHeartbeatSeconds(@Nullable Number value) {
            this._heartbeatSeconds = value;
            return this;
        }

        public Builder withInputPath(@Nullable String value) {
            this._inputPath = value;
            return this;
        }

        public Builder withOutputPath(@Nullable String value) {
            this._outputPath = value;
            return this;
        }

        public Builder withParameters(@Nullable Map<String, Object> value) {
            this._parameters = value;
            return this;
        }

        public Builder withResultPath(@Nullable String value) {
            this._resultPath = value;
            return this;
        }

        public Builder withTimeoutSeconds(@Nullable Number value) {
            this._timeoutSeconds = value;
            return this;
        }

        public TaskProps build() {
            return new TaskProps(){
                private final IStepFunctionsTaskResource $resource;
                @Nullable
                private final String $comment;
                @Nullable
                private final Number $heartbeatSeconds;
                @Nullable
                private final String $inputPath;
                @Nullable
                private final String $outputPath;
                @Nullable
                private final Map<String, Object> $parameters;
                @Nullable
                private final String $resultPath;
                @Nullable
                private final Number $timeoutSeconds;
                {
                    this.$resource = Objects.requireNonNull(_resource, "resource is required");
                    this.$comment = _comment;
                    this.$heartbeatSeconds = _heartbeatSeconds;
                    this.$inputPath = _inputPath;
                    this.$outputPath = _outputPath;
                    this.$parameters = _parameters;
                    this.$resultPath = _resultPath;
                    this.$timeoutSeconds = _timeoutSeconds;
                }

                @Override
                public IStepFunctionsTaskResource getResource() {
                    return this.$resource;
                }

                @Override
                public String getComment() {
                    return this.$comment;
                }

                @Override
                public Number getHeartbeatSeconds() {
                    return this.$heartbeatSeconds;
                }

                @Override
                public String getInputPath() {
                    return this.$inputPath;
                }

                @Override
                public String getOutputPath() {
                    return this.$outputPath;
                }

                @Override
                public Map<String, Object> getParameters() {
                    return this.$parameters;
                }

                @Override
                public String getResultPath() {
                    return this.$resultPath;
                }

                @Override
                public Number getTimeoutSeconds() {
                    return this.$timeoutSeconds;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("resource", om.valueToTree((Object)this.getResource()));
                    obj.set("comment", om.valueToTree((Object)this.getComment()));
                    obj.set("heartbeatSeconds", om.valueToTree((Object)this.getHeartbeatSeconds()));
                    obj.set("inputPath", om.valueToTree((Object)this.getInputPath()));
                    obj.set("outputPath", om.valueToTree((Object)this.getOutputPath()));
                    obj.set("parameters", om.valueToTree(this.getParameters()));
                    obj.set("resultPath", om.valueToTree((Object)this.getResultPath()));
                    obj.set("timeoutSeconds", om.valueToTree((Object)this.getTimeoutSeconds()));
                    return obj;
                }
            };
        }
    }
}

